package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Gateway Time-out
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class GatewayTimeout extends HttpError {

private static final long serialVersionUID = -3794925927436375671L;

/** HTTP status code for 'Gateway Time-out' */
public static final int code = 504;

/** Create a 'Gateway Time-out' HTTP Response. */
public GatewayTimeout() {
super(504,"Gateway Time-out");
}

/** Create a 'Gateway Time-out' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public GatewayTimeout(Throwable t) {
super(504,"Gateway Time-out", t);
}

/** Create a 'Gateway Time-out' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public GatewayTimeout(String m) {
super(504,"Gateway Time-out", m);
}

/** Create a 'Gateway Time-out' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public GatewayTimeout(String m, Throwable t) {
super(504,"Gateway Time-out", m, t);
}

}
