package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Continue
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class Continue extends HttpError {

private static final long serialVersionUID = 3222427689515756858L;

/** HTTP status code for 'Continue' */
public static final int code = 100;

/** Create a 'Continue' HTTP Response. */
public Continue() {
super(100,"Continue");
}

/** Create a 'Continue' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public Continue(Throwable t) {
super(100,"Continue", t);
}

/** Create a 'Continue' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public Continue(String m) {
super(100,"Continue", m);
}

/** Create a 'Continue' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public Continue(String m, Throwable t) {
super(100,"Continue", m, t);
}

}
