package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Use Proxy
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class UseProxy extends HttpError {

private static final long serialVersionUID = -583560639337399108L;

/** HTTP status code for 'Use Proxy' */
public static final int code = 305;

/** Create a 'Use Proxy' HTTP Response. */
public UseProxy() {
super(305,"Use Proxy");
}

/** Create a 'Use Proxy' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public UseProxy(Throwable t) {
super(305,"Use Proxy", t);
}

/** Create a 'Use Proxy' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public UseProxy(String m) {
super(305,"Use Proxy", m);
}

/** Create a 'Use Proxy' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public UseProxy(String m, Throwable t) {
super(305,"Use Proxy", m, t);
}

}
