package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Reset Content
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class ResetContent extends HttpError {

private static final long serialVersionUID = 1550312460382911802L;

/** HTTP status code for 'Reset Content' */
public static final int code = 205;

/** Create a 'Reset Content' HTTP Response. */
public ResetContent() {
super(205,"Reset Content");
}

/** Create a 'Reset Content' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public ResetContent(Throwable t) {
super(205,"Reset Content", t);
}

/** Create a 'Reset Content' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public ResetContent(String m) {
super(205,"Reset Content", m);
}

/** Create a 'Reset Content' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public ResetContent(String m, Throwable t) {
super(205,"Reset Content", m, t);
}

}
