package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Range Not Satisfiable
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class RangeNotSatisfiable extends HttpError {

private static final long serialVersionUID = -3544016730298439552L;

/** HTTP status code for 'Range Not Satisfiable' */
public static final int code = 416;

/** Create a 'Range Not Satisfiable' HTTP Response. */
public RangeNotSatisfiable() {
super(416,"Range Not Satisfiable");
}

/** Create a 'Range Not Satisfiable' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public RangeNotSatisfiable(Throwable t) {
super(416,"Range Not Satisfiable", t);
}

/** Create a 'Range Not Satisfiable' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public RangeNotSatisfiable(String m) {
super(416,"Range Not Satisfiable", m);
}

/** Create a 'Range Not Satisfiable' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public RangeNotSatisfiable(String m, Throwable t) {
super(416,"Range Not Satisfiable", m, t);
}

}
