package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Partial Content
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class PartialContent extends HttpError {

private static final long serialVersionUID = -3260372562630470262L;

/** HTTP status code for 'Partial Content' */
public static final int code = 206;

/** Create a 'Partial Content' HTTP Response. */
public PartialContent() {
super(206,"Partial Content");
}

/** Create a 'Partial Content' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public PartialContent(Throwable t) {
super(206,"Partial Content", t);
}

/** Create a 'Partial Content' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public PartialContent(String m) {
super(206,"Partial Content", m);
}

/** Create a 'Partial Content' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public PartialContent(String m, Throwable t) {
super(206,"Partial Content", m, t);
}

}
