package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Not Found
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class NotFound extends HttpError {

private static final long serialVersionUID = 5051464278982846224L;

/** HTTP status code for 'Not Found' */
public static final int code = 404;

/** Create a 'Not Found' HTTP Response. */
public NotFound() {
super(404,"Not Found");
}

/** Create a 'Not Found' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public NotFound(Throwable t) {
super(404,"Not Found", t);
}

/** Create a 'Not Found' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public NotFound(String m) {
super(404,"Not Found", m);
}

/** Create a 'Not Found' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public NotFound(String m, Throwable t) {
super(404,"Not Found", m, t);
}

}
