package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Non-Authoritative Information
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class NonAuthoritativeInformation extends HttpError {

private static final long serialVersionUID = -7140966728893140415L;

/** HTTP status code for 'Non-Authoritative Information' */
public static final int code = 203;

/** Create a 'Non-Authoritative Information' HTTP Response. */
public NonAuthoritativeInformation() {
super(203,"Non-Authoritative Information");
}

/** Create a 'Non-Authoritative Information' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public NonAuthoritativeInformation(Throwable t) {
super(203,"Non-Authoritative Information", t);
}

/** Create a 'Non-Authoritative Information' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public NonAuthoritativeInformation(String m) {
super(203,"Non-Authoritative Information", m);
}

/** Create a 'Non-Authoritative Information' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public NonAuthoritativeInformation(String m, Throwable t) {
super(203,"Non-Authoritative Information", m, t);
}

}
