package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for No Content
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class NoContent extends HttpError {

private static final long serialVersionUID = -4515469759267603238L;

/** HTTP status code for 'No Content' */
public static final int code = 204;

/** Create a 'No Content' HTTP Response. */
public NoContent() {
super(204,"No Content");
}

/** Create a 'No Content' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public NoContent(Throwable t) {
super(204,"No Content", t);
}

/** Create a 'No Content' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public NoContent(String m) {
super(204,"No Content", m);
}

/** Create a 'No Content' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public NoContent(String m, Throwable t) {
super(204,"No Content", m, t);
}

}
