package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Moved Permanently
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class MovedPermanently extends HttpError {

private static final long serialVersionUID = -2127500604690045152L;

/** HTTP status code for 'Moved Permanently' */
public static final int code = 301;

/** Create a 'Moved Permanently' HTTP Response. */
public MovedPermanently() {
super(301,"Moved Permanently");
}

/** Create a 'Moved Permanently' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public MovedPermanently(Throwable t) {
super(301,"Moved Permanently", t);
}

/** Create a 'Moved Permanently' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public MovedPermanently(String m) {
super(301,"Moved Permanently", m);
}

/** Create a 'Moved Permanently' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public MovedPermanently(String m, Throwable t) {
super(301,"Moved Permanently", m, t);
}

}
