package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Method Not Allowed
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class MethodNotAllowed extends HttpError {

private static final long serialVersionUID = -8293694385372313798L;

/** HTTP status code for 'Method Not Allowed' */
public static final int code = 405;

/** Create a 'Method Not Allowed' HTTP Response. */
public MethodNotAllowed() {
super(405,"Method Not Allowed");
}

/** Create a 'Method Not Allowed' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public MethodNotAllowed(Throwable t) {
super(405,"Method Not Allowed", t);
}

/** Create a 'Method Not Allowed' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public MethodNotAllowed(String m) {
super(405,"Method Not Allowed", m);
}

/** Create a 'Method Not Allowed' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public MethodNotAllowed(String m, Throwable t) {
super(405,"Method Not Allowed", m, t);
}

}
