package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Internal Server Error
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class InternalServerError extends HttpError {

private static final long serialVersionUID = 8158369589559874663L;

/** HTTP status code for 'Internal Server Error' */
public static final int code = 500;

/** Create a 'Internal Server Error' HTTP Response. */
public InternalServerError() {
super(500,"Internal Server Error");
}

/** Create a 'Internal Server Error' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public InternalServerError(Throwable t) {
super(500,"Internal Server Error", t);
}

/** Create a 'Internal Server Error' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public InternalServerError(String m) {
super(500,"Internal Server Error", m);
}

/** Create a 'Internal Server Error' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public InternalServerError(String m, Throwable t) {
super(500,"Internal Server Error", m, t);
}

}
