package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for IM Used
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class IMUsed extends HttpError {

private static final long serialVersionUID = 7311641056191768146L;

/** HTTP status code for 'IM Used' */
public static final int code = 226;

/** Create a 'IM Used' HTTP Response. */
public IMUsed() {
super(226,"IM Used");
}

/** Create a 'IM Used' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public IMUsed(Throwable t) {
super(226,"IM Used", t);
}

/** Create a 'IM Used' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public IMUsed(String m) {
super(226,"IM Used", m);
}

/** Create a 'IM Used' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public IMUsed(String m, Throwable t) {
super(226,"IM Used", m, t);
}

}
