package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Created
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class Created extends HttpError {

private static final long serialVersionUID = 463586688441277319L;

/** HTTP status code for 'Created' */
public static final int code = 201;

/** Create a 'Created' HTTP Response. */
public Created() {
super(201,"Created");
}

/** Create a 'Created' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public Created(Throwable t) {
super(201,"Created", t);
}

/** Create a 'Created' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public Created(String m) {
super(201,"Created", m);
}

/** Create a 'Created' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public Created(String m, Throwable t) {
super(201,"Created", m, t);
}

}
