package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Conflict
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class Conflict extends HttpError {

private static final long serialVersionUID = -1056976263606207176L;

/** HTTP status code for 'Conflict' */
public static final int code = 409;

/** Create a 'Conflict' HTTP Response. */
public Conflict() {
super(409,"Conflict");
}

/** Create a 'Conflict' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public Conflict(Throwable t) {
super(409,"Conflict", t);
}

/** Create a 'Conflict' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public Conflict(String m) {
super(409,"Conflict", m);
}

/** Create a 'Conflict' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public Conflict(String m, Throwable t) {
super(409,"Conflict", m, t);
}

}
