package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Bad Request
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class BadRequest extends HttpError {

private static final long serialVersionUID = 6860145167390143241L;

/** HTTP status code for 'Bad Request' */
public static final int code = 400;

/** Create a 'Bad Request' HTTP Response. */
public BadRequest() {
super(400,"Bad Request");
}

/** Create a 'Bad Request' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public BadRequest(Throwable t) {
super(400,"Bad Request", t);
}

/** Create a 'Bad Request' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public BadRequest(String m) {
super(400,"Bad Request", m);
}

/** Create a 'Bad Request' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public BadRequest(String m, Throwable t) {
super(400,"Bad Request", m, t);
}

}
