package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Accepted
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class Accepted extends HttpError {

private static final long serialVersionUID = 4053094911747535280L;

/** HTTP status code for 'Accepted' */
public static final int code = 202;

/** Create a 'Accepted' HTTP Response. */
public Accepted() {
super(202,"Accepted");
}

/** Create a 'Accepted' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public Accepted(Throwable t) {
super(202,"Accepted", t);
}

/** Create a 'Accepted' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public Accepted(String m) {
super(202,"Accepted", m);
}

/** Create a 'Accepted' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public Accepted(String m, Throwable t) {
super(202,"Accepted", m, t);
}

}
