/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.tests.markup;

import com.aventstack.extentreports.model.Log;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import tech.grasshopper.reporter.config.ExtentPDFReporterConfig;
import tech.grasshopper.reporter.tests.markup.CodeBlockMarkup;
import tech.grasshopper.reporter.tests.markup.DefaultMarkup;
import tech.grasshopper.reporter.tests.markup.JsonMarkup;
import tech.grasshopper.reporter.tests.markup.LabelMarkup;
import tech.grasshopper.reporter.tests.markup.MarkupDisplay;
import tech.grasshopper.reporter.tests.markup.OrderedListMarkup;
import tech.grasshopper.reporter.tests.markup.TableMarkup;
import tech.grasshopper.reporter.tests.markup.UnorderedListMarkup;

public class TestMarkup {
    private Log log;
    private float width;
    private ExtentPDFReporterConfig config;

    public AbstractCell createMarkupCell() {
        String html = this.log.getDetails();
        Document doc = Jsoup.parseBodyFragment((String)html);
        Element element = doc.selectFirst("body > span[class*=\"badge\"]");
        if (element != null) {
            return ((LabelMarkup)((LabelMarkup.LabelMarkupBuilder)LabelMarkup.builder().element(element)).build()).displayDetails();
        }
        element = doc.selectFirst("body > table[class*=\"markup-table table\"]");
        if (element != null) {
            return ((TableMarkup)((TableMarkup.TableMarkupBuilder)((TableMarkup.TableMarkupBuilder)((TableMarkup.TableMarkupBuilder)((TableMarkup.TableMarkupBuilder)((TableMarkup.TableMarkupBuilder)TableMarkup.builder().element(element)).textColor(this.config.statusColor(this.log.getStatus()))).maxTableColumnCount(this.config.getMaxTableColumnCount())).maxTableRowCount(this.config.getMaxTableRowCount())).width(this.width)).build()).displayDetails();
        }
        Elements elements = doc.select("body > ol > li");
        if (elements.size() > 0) {
            return ((OrderedListMarkup)((OrderedListMarkup.OrderedListMarkupBuilder)((OrderedListMarkup.OrderedListMarkupBuilder)OrderedListMarkup.builder().elements(elements)).textColor(this.config.statusColor(this.log.getStatus()))).build()).displayDetails();
        }
        elements = doc.select("body > ul > li");
        if (elements.size() > 0) {
            return ((UnorderedListMarkup)((UnorderedListMarkup.UnorderedListMarkupBuilder)((UnorderedListMarkup.UnorderedListMarkupBuilder)UnorderedListMarkup.builder().elements(elements)).textColor(this.config.statusColor(this.log.getStatus()))).build()).displayDetails();
        }
        elements = doc.select("body textarea[class*=\"code-block\"]");
        if (elements.size() > 0) {
            return ((CodeBlockMarkup)((CodeBlockMarkup.CodeBlockMarkupBuilder)((CodeBlockMarkup.CodeBlockMarkupBuilder)((CodeBlockMarkup.CodeBlockMarkupBuilder)((CodeBlockMarkup.CodeBlockMarkupBuilder)CodeBlockMarkup.builder().elements(elements)).textColor(this.config.statusColor(this.log.getStatus()))).maxCodeBlockCount(this.config.getMaxCodeBlockCount())).width(this.width)).build()).displayDetails();
        }
        if (html.contains("JSONTree")) {
            return ((JsonMarkup)((JsonMarkup.JsonMarkupBuilder)((MarkupDisplay.MarkupDisplayBuilder)JsonMarkup.builder().html(html)).textColor(this.config.statusColor(this.log.getStatus()))).build()).displayDetails();
        }
        return ((DefaultMarkup)((DefaultMarkup.DefaultMarkupBuilder)((MarkupDisplay.MarkupDisplayBuilder)DefaultMarkup.builder().log(this.log)).textColor(this.config.statusColor(this.log.getStatus()))).build()).displayDetails();
    }

    public static boolean isMarkup(String markup) {
        return markup.trim().startsWith("<") && markup.trim().endsWith(">");
    }

    TestMarkup(Log log, float width, ExtentPDFReporterConfig config) {
        this.log = log;
        this.width = width;
        this.config = config;
    }

    public static TestMarkupBuilder builder() {
        return new TestMarkupBuilder();
    }

    public Log getLog() {
        return this.log;
    }

    public float getWidth() {
        return this.width;
    }

    public ExtentPDFReporterConfig getConfig() {
        return this.config;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setConfig(ExtentPDFReporterConfig config) {
        this.config = config;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestMarkup)) {
            return false;
        }
        TestMarkup other = (TestMarkup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getWidth(), other.getWidth()) != 0) {
            return false;
        }
        Log this$log = this.getLog();
        Log other$log = other.getLog();
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        ExtentPDFReporterConfig this$config = this.getConfig();
        ExtentPDFReporterConfig other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !((Object)((Object)this$config)).equals((Object)other$config));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestMarkup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getWidth());
        Log $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        ExtentPDFReporterConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)((Object)$config)).hashCode());
        return result;
    }

    public String toString() {
        return "TestMarkup(log=" + this.getLog() + ", width=" + this.getWidth() + ", config=" + (Object)((Object)this.getConfig()) + ")";
    }

    public static class TestMarkupBuilder {
        private Log log;
        private float width;
        private ExtentPDFReporterConfig config;

        TestMarkupBuilder() {
        }

        public TestMarkupBuilder log(Log log) {
            this.log = log;
            return this;
        }

        public TestMarkupBuilder width(float width) {
            this.width = width;
            return this;
        }

        public TestMarkupBuilder config(ExtentPDFReporterConfig config) {
            this.config = config;
            return this;
        }

        public TestMarkup build() {
            return new TestMarkup(this.log, this.width, this.config);
        }

        public String toString() {
            return "TestMarkup.TestMarkupBuilder(log=" + this.log + ", width=" + this.width + ", config=" + (Object)((Object)this.config) + ")";
        }
    }
}

