/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.tests.markup;

import java.awt.Color;
import java.util.Arrays;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.structure.cell.TableWithinTableCell;
import tech.grasshopper.reporter.font.ReportFont;
import tech.grasshopper.reporter.tests.markup.MarkupDisplay;

public class TableMarkup
extends MarkupDisplay {
    private float width;
    private int maxTableColumnCount;
    private int maxTableRowCount;

    @Override
    public AbstractCell displayDetails() {
        return TableWithinTableCell.builder().table(this.internalTable()).build();
    }

    private Table internalTable() {
        Elements rows = this.element.select("tr");
        int cols = ((Element)rows.get(0)).select("td").size();
        boolean maxCols = cols > this.maxTableColumnCount;
        cols = cols > this.maxTableColumnCount ? this.maxTableColumnCount : cols;
        float colWidth = this.width / (float)cols;
        float[] columnWidths = new float[cols];
        Arrays.fill(columnWidths, colWidth);
        boolean maxRows = false;
        int rowCnt = rows.size();
        if (this.maxTableRowCount > 0) {
            maxRows = rows.size() > this.maxTableRowCount;
            rowCnt = rows.size() > this.maxTableRowCount ? this.maxTableRowCount : rows.size();
        }
        Table.TableBuilder tableBuilder = Table.builder().addColumnsOfWidth(columnWidths).fontSize(Integer.valueOf(11)).font(this.LOG_FONT).borderWidth(1.0f).borderColor(Color.LIGHT_GRAY).wordBreak(Boolean.valueOf(true));
        int i = 1;
        for (Element row : rows) {
            if (i > rowCnt) break;
            Row.RowBuilder rowBuilder = Row.builder();
            int j = 1;
            for (Element cell : row.select("td")) {
                if (j > cols) break;
                rowBuilder.add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(this.textSanitizer.sanitizeText(cell.text())).textColor(this.textColor)).lineSpacing(1.0f)).build());
                ++j;
            }
            tableBuilder.addRow(rowBuilder.build());
            ++i;
        }
        String tableCounts = "";
        String tableSettings = "";
        if (maxCols) {
            tableCounts = this.maxTableColumnCount + " columns";
            tableSettings = "'maxTableColumnCount'";
        }
        if (maxRows) {
            if (maxCols) {
                tableCounts = this.maxTableColumnCount + " columns and " + this.maxTableRowCount + " rows";
                tableSettings = "'maxTableColumnCount' and 'maxTableRowCount'";
            } else {
                tableCounts = this.maxTableRowCount + " rows";
                tableSettings = "'maxTableRowCount' ";
            }
        }
        if (maxCols || maxRows) {
            tableBuilder.addRow(Row.builder().add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().colSpan(cols)).text("Only first " + tableCounts + " are shown. Change this from the " + tableSettings + " settings.").minHeight(15.0f)).font(ReportFont.REGULAR_FONT)).fontSize(Integer.valueOf(10))).textColor(Color.RED)).wordBreak(Boolean.valueOf(true))).lineSpacing(1.0f)).build()).build());
        }
        return tableBuilder.build();
    }

    protected TableMarkup(TableMarkupBuilder<?, ?> b) {
        super(b);
        this.width = ((TableMarkupBuilder)b).width;
        this.maxTableColumnCount = ((TableMarkupBuilder)b).maxTableColumnCount;
        this.maxTableRowCount = ((TableMarkupBuilder)b).maxTableRowCount;
    }

    public static TableMarkupBuilder<?, ?> builder() {
        return new TableMarkupBuilderImpl();
    }

    public float getWidth() {
        return this.width;
    }

    public int getMaxTableColumnCount() {
        return this.maxTableColumnCount;
    }

    public int getMaxTableRowCount() {
        return this.maxTableRowCount;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setMaxTableColumnCount(int maxTableColumnCount) {
        this.maxTableColumnCount = maxTableColumnCount;
    }

    public void setMaxTableRowCount(int maxTableRowCount) {
        this.maxTableRowCount = maxTableRowCount;
    }

    @Override
    public String toString() {
        return "TableMarkup(width=" + this.getWidth() + ", maxTableColumnCount=" + this.getMaxTableColumnCount() + ", maxTableRowCount=" + this.getMaxTableRowCount() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableMarkup)) {
            return false;
        }
        TableMarkup other = (TableMarkup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getWidth(), other.getWidth()) != 0) {
            return false;
        }
        if (this.getMaxTableColumnCount() != other.getMaxTableColumnCount()) {
            return false;
        }
        return this.getMaxTableRowCount() == other.getMaxTableRowCount();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TableMarkup;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getWidth());
        result = result * 59 + this.getMaxTableColumnCount();
        result = result * 59 + this.getMaxTableRowCount();
        return result;
    }

    private static final class TableMarkupBuilderImpl
    extends TableMarkupBuilder<TableMarkup, TableMarkupBuilderImpl> {
        private TableMarkupBuilderImpl() {
        }

        @Override
        protected TableMarkupBuilderImpl self() {
            return this;
        }

        @Override
        public TableMarkup build() {
            return new TableMarkup(this);
        }
    }

    public static abstract class TableMarkupBuilder<C extends TableMarkup, B extends TableMarkupBuilder<C, B>>
    extends MarkupDisplay.MarkupDisplayBuilder<C, B> {
        private float width;
        private int maxTableColumnCount;
        private int maxTableRowCount;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B width(float width) {
            this.width = width;
            return (B)this.self();
        }

        public B maxTableColumnCount(int maxTableColumnCount) {
            this.maxTableColumnCount = maxTableColumnCount;
            return (B)this.self();
        }

        public B maxTableRowCount(int maxTableRowCount) {
            this.maxTableRowCount = maxTableRowCount;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TableMarkup.TableMarkupBuilder(super=" + super.toString() + ", width=" + this.width + ", maxTableColumnCount=" + this.maxTableColumnCount + ", maxTableRowCount=" + this.maxTableRowCount + ")";
        }
    }
}

