/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.tests.markup;

import org.jsoup.nodes.Element;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.structure.cell.TableWithinTableCell;
import tech.grasshopper.reporter.tests.markup.MarkupDisplay;

public class OrderedListMarkup
extends MarkupDisplay {
    @Override
    public AbstractCell displayDetails() {
        return TableWithinTableCell.builder().table(this.listTable()).build();
    }

    private Table listTable() {
        Table.TableBuilder tableBuilder = Table.builder().addColumnsOfWidth(new float[]{25.0f, 420.0f}).fontSize(Integer.valueOf(11)).font(this.LOG_FONT).borderWidth(0.0f).wordBreak(Boolean.valueOf(true));
        int sno = 1;
        for (Element e : this.elements) {
            tableBuilder.addRow(Row.builder().add((AbstractCell)TextCell.builder().text(String.valueOf(sno)).build()).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(this.textSanitizer.sanitizeText(e.text())).textColor(this.textColor)).lineSpacing(1.0f)).build()).build());
            ++sno;
        }
        return tableBuilder.build();
    }

    protected OrderedListMarkup(OrderedListMarkupBuilder<?, ?> b) {
        super(b);
    }

    public static OrderedListMarkupBuilder<?, ?> builder() {
        return new OrderedListMarkupBuilderImpl();
    }

    @Override
    public String toString() {
        return "OrderedListMarkup()";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderedListMarkup)) {
            return false;
        }
        OrderedListMarkup other = (OrderedListMarkup)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OrderedListMarkup;
    }

    @Override
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static final class OrderedListMarkupBuilderImpl
    extends OrderedListMarkupBuilder<OrderedListMarkup, OrderedListMarkupBuilderImpl> {
        private OrderedListMarkupBuilderImpl() {
        }

        @Override
        protected OrderedListMarkupBuilderImpl self() {
            return this;
        }

        @Override
        public OrderedListMarkup build() {
            return new OrderedListMarkup(this);
        }
    }

    public static abstract class OrderedListMarkupBuilder<C extends OrderedListMarkup, B extends OrderedListMarkupBuilder<C, B>>
    extends MarkupDisplay.MarkupDisplayBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "OrderedListMarkup.OrderedListMarkupBuilder(super=" + super.toString() + ")";
        }
    }
}

