/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.tests.markup;

import java.awt.Color;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import tech.grasshopper.reporter.font.ReportFont;
import tech.grasshopper.reporter.optimizer.TextSanitizer;

public abstract class MarkupDisplay {
    protected final float BORDER_WIDTH = 1.0f;
    protected final float MULTILINE_SPACING = 1.0f;
    protected final PDFont LOG_FONT = ReportFont.REGULAR_FONT;
    protected final int LOG_FONT_SIZE = 11;
    protected Element element;
    protected Elements elements;
    protected Color textColor;
    protected final TextSanitizer textSanitizer = TextSanitizer.builder().font(this.LOG_FONT).build();

    public abstract AbstractCell displayDetails();

    private static Color $default$textColor() {
        return Color.BLACK;
    }

    protected MarkupDisplay(MarkupDisplayBuilder<?, ?> b) {
        this.element = ((MarkupDisplayBuilder)b).element;
        this.elements = ((MarkupDisplayBuilder)b).elements;
        this.textColor = ((MarkupDisplayBuilder)b).textColor$set ? ((MarkupDisplayBuilder)b).textColor$value : MarkupDisplay.$default$textColor();
    }

    public float getBORDER_WIDTH() {
        this.getClass();
        return 1.0f;
    }

    public float getMULTILINE_SPACING() {
        this.getClass();
        return 1.0f;
    }

    public PDFont getLOG_FONT() {
        return this.LOG_FONT;
    }

    public int getLOG_FONT_SIZE() {
        return this.LOG_FONT_SIZE;
    }

    public Element getElement() {
        return this.element;
    }

    public Elements getElements() {
        return this.elements;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public TextSanitizer getTextSanitizer() {
        return this.textSanitizer;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public void setElements(Elements elements) {
        this.elements = elements;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MarkupDisplay)) {
            return false;
        }
        MarkupDisplay other = (MarkupDisplay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getBORDER_WIDTH(), other.getBORDER_WIDTH()) != 0) {
            return false;
        }
        if (Float.compare(this.getMULTILINE_SPACING(), other.getMULTILINE_SPACING()) != 0) {
            return false;
        }
        if (this.getLOG_FONT_SIZE() != other.getLOG_FONT_SIZE()) {
            return false;
        }
        PDFont this$LOG_FONT = this.getLOG_FONT();
        PDFont other$LOG_FONT = other.getLOG_FONT();
        if (this$LOG_FONT == null ? other$LOG_FONT != null : !this$LOG_FONT.equals(other$LOG_FONT)) {
            return false;
        }
        Element this$element = this.getElement();
        Element other$element = other.getElement();
        if (this$element == null ? other$element != null : !this$element.equals(other$element)) {
            return false;
        }
        Elements this$elements = this.getElements();
        Elements other$elements = other.getElements();
        if (this$elements == null ? other$elements != null : !this$elements.equals(other$elements)) {
            return false;
        }
        Color this$textColor = this.getTextColor();
        Color other$textColor = other.getTextColor();
        if (this$textColor == null ? other$textColor != null : !((Object)this$textColor).equals(other$textColor)) {
            return false;
        }
        TextSanitizer this$textSanitizer = this.getTextSanitizer();
        TextSanitizer other$textSanitizer = other.getTextSanitizer();
        return !(this$textSanitizer == null ? other$textSanitizer != null : !((Object)this$textSanitizer).equals(other$textSanitizer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MarkupDisplay;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getBORDER_WIDTH());
        result = result * 59 + Float.floatToIntBits(this.getMULTILINE_SPACING());
        result = result * 59 + this.getLOG_FONT_SIZE();
        PDFont $LOG_FONT = this.getLOG_FONT();
        result = result * 59 + ($LOG_FONT == null ? 43 : $LOG_FONT.hashCode());
        Element $element = this.getElement();
        result = result * 59 + ($element == null ? 43 : $element.hashCode());
        Elements $elements = this.getElements();
        result = result * 59 + ($elements == null ? 43 : $elements.hashCode());
        Color $textColor = this.getTextColor();
        result = result * 59 + ($textColor == null ? 43 : ((Object)$textColor).hashCode());
        TextSanitizer $textSanitizer = this.getTextSanitizer();
        result = result * 59 + ($textSanitizer == null ? 43 : ((Object)$textSanitizer).hashCode());
        return result;
    }

    public String toString() {
        return "MarkupDisplay(BORDER_WIDTH=" + this.getBORDER_WIDTH() + ", MULTILINE_SPACING=" + this.getMULTILINE_SPACING() + ", LOG_FONT=" + this.getLOG_FONT() + ", LOG_FONT_SIZE=" + this.getLOG_FONT_SIZE() + ", element=" + this.getElement() + ", elements=" + this.getElements() + ", textColor=" + this.getTextColor() + ", textSanitizer=" + this.getTextSanitizer() + ")";
    }

    public static abstract class MarkupDisplayBuilder<C extends MarkupDisplay, B extends MarkupDisplayBuilder<C, B>> {
        private Element element;
        private Elements elements;
        private boolean textColor$set;
        private Color textColor$value;

        protected abstract B self();

        public abstract C build();

        public B element(Element element) {
            this.element = element;
            return this.self();
        }

        public B elements(Elements elements) {
            this.elements = elements;
            return this.self();
        }

        public B textColor(Color textColor) {
            this.textColor$value = textColor;
            this.textColor$set = true;
            return this.self();
        }

        public String toString() {
            return "MarkupDisplay.MarkupDisplayBuilder(element=" + this.element + ", elements=" + this.elements + ", textColor$value=" + this.textColor$value + ")";
        }
    }
}

