/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.tests.markup;

import java.awt.Color;
import org.jsoup.nodes.Element;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.structure.cell.TableWithinTableCell;
import tech.grasshopper.reporter.font.ReportFont;
import tech.grasshopper.reporter.tests.markup.MarkupDisplay;

public class CodeBlockMarkup
extends MarkupDisplay {
    private float width;
    private int maxCodeBlockCount;

    @Override
    public AbstractCell displayDetails() {
        return TableWithinTableCell.builder().table(this.codeTable()).build();
    }

    private Table codeTable() {
        boolean maxCodes = false;
        int count = this.elements.size();
        if (this.maxCodeBlockCount > 0) {
            maxCodes = this.elements.size() > this.maxCodeBlockCount;
            count = this.elements.size() > this.maxCodeBlockCount ? this.maxCodeBlockCount : this.elements.size();
        }
        Table.TableBuilder tableBuilder = Table.builder().addColumnsOfWidth(new float[]{this.width}).fontSize(Integer.valueOf(11)).font(this.LOG_FONT).borderWidth(1.0f).borderColor(Color.LIGHT_GRAY).wordBreak(Boolean.valueOf(true)).padding(5.0f);
        int i = 1;
        for (Element e : this.elements) {
            if (i > count) break;
            tableBuilder.addRow(Row.builder().add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(this.textSanitizer.sanitizeText(e.text())).textColor(this.textColor)).lineSpacing(1.0f)).build()).build());
            ++i;
        }
        if (maxCodes) {
            tableBuilder.addRow(Row.builder().add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text("Only first " + this.maxCodeBlockCount + " code blocks are shown. Change this from the 'maxCodeBlockCount' setting.").minHeight(15.0f)).font(ReportFont.REGULAR_FONT)).fontSize(Integer.valueOf(10))).textColor(Color.RED)).lineSpacing(1.0f)).build()).build());
        }
        return tableBuilder.build();
    }

    protected CodeBlockMarkup(CodeBlockMarkupBuilder<?, ?> b) {
        super(b);
        this.width = ((CodeBlockMarkupBuilder)b).width;
        this.maxCodeBlockCount = ((CodeBlockMarkupBuilder)b).maxCodeBlockCount;
    }

    public static CodeBlockMarkupBuilder<?, ?> builder() {
        return new CodeBlockMarkupBuilderImpl();
    }

    public float getWidth() {
        return this.width;
    }

    public int getMaxCodeBlockCount() {
        return this.maxCodeBlockCount;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setMaxCodeBlockCount(int maxCodeBlockCount) {
        this.maxCodeBlockCount = maxCodeBlockCount;
    }

    @Override
    public String toString() {
        return "CodeBlockMarkup(width=" + this.getWidth() + ", maxCodeBlockCount=" + this.getMaxCodeBlockCount() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CodeBlockMarkup)) {
            return false;
        }
        CodeBlockMarkup other = (CodeBlockMarkup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getWidth(), other.getWidth()) != 0) {
            return false;
        }
        return this.getMaxCodeBlockCount() == other.getMaxCodeBlockCount();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CodeBlockMarkup;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getWidth());
        result = result * 59 + this.getMaxCodeBlockCount();
        return result;
    }

    private static final class CodeBlockMarkupBuilderImpl
    extends CodeBlockMarkupBuilder<CodeBlockMarkup, CodeBlockMarkupBuilderImpl> {
        private CodeBlockMarkupBuilderImpl() {
        }

        @Override
        protected CodeBlockMarkupBuilderImpl self() {
            return this;
        }

        @Override
        public CodeBlockMarkup build() {
            return new CodeBlockMarkup(this);
        }
    }

    public static abstract class CodeBlockMarkupBuilder<C extends CodeBlockMarkup, B extends CodeBlockMarkupBuilder<C, B>>
    extends MarkupDisplay.MarkupDisplayBuilder<C, B> {
        private float width;
        private int maxCodeBlockCount;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B width(float width) {
            this.width = width;
            return (B)this.self();
        }

        public B maxCodeBlockCount(int maxCodeBlockCount) {
            this.maxCodeBlockCount = maxCodeBlockCount;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "CodeBlockMarkup.CodeBlockMarkupBuilder(super=" + super.toString() + ", width=" + this.width + ", maxCodeBlockCount=" + this.maxCodeBlockCount + ")";
        }
    }
}

