/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.tests;

import com.aventstack.extentreports.model.Log;
import java.awt.Color;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.reporter.font.ReportFont;
import tech.grasshopper.reporter.optimizer.TextSanitizer;

public class TestStackTrace {
    private Log log;
    private PDFont font;
    private int fontSize;
    private float padding;
    private float width;
    private float lineSpacing;
    private float height;
    private Color color;

    public TextCell createStackTraceCell() {
        TextSanitizer sanitizer = TextSanitizer.builder().font(this.font).replaceBy("").build();
        String stackTrace = this.log.getException().getStackTrace();
        String stackText = "";
        if (stackTrace != null && !stackTrace.isEmpty()) {
            String[] lines = stackTrace.trim().split("\\r?\\n");
            ArrayList<String> splitLines = new ArrayList<String>();
            for (String line : lines) {
                splitLines.add(sanitizer.sanitizeText(line));
            }
            stackText = splitLines.stream().collect(Collectors.joining(System.getProperty("line.separator")));
        }
        return ((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(stackText).lineSpacing(this.lineSpacing)).minHeight(this.height)).font(ReportFont.REGULAR_FONT)).fontSize(Integer.valueOf(this.fontSize))).wordBreak(Boolean.valueOf(true))).textColor(this.color)).build();
    }

    private static float $default$lineSpacing() {
        return 1.0f;
    }

    private static Color $default$color() {
        return Color.RED;
    }

    TestStackTrace(Log log, PDFont font, int fontSize, float padding, float width, float lineSpacing, float height, Color color) {
        this.log = log;
        this.font = font;
        this.fontSize = fontSize;
        this.padding = padding;
        this.width = width;
        this.lineSpacing = lineSpacing;
        this.height = height;
        this.color = color;
    }

    public static TestStackTraceBuilder builder() {
        return new TestStackTraceBuilder();
    }

    public Log getLog() {
        return this.log;
    }

    public PDFont getFont() {
        return this.font;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public float getPadding() {
        return this.padding;
    }

    public float getWidth() {
        return this.width;
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public float getHeight() {
        return this.height;
    }

    public Color getColor() {
        return this.color;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setFont(PDFont font) {
        this.font = font;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public void setPadding(float padding) {
        this.padding = padding;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setLineSpacing(float lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestStackTrace)) {
            return false;
        }
        TestStackTrace other = (TestStackTrace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFontSize() != other.getFontSize()) {
            return false;
        }
        if (Float.compare(this.getPadding(), other.getPadding()) != 0) {
            return false;
        }
        if (Float.compare(this.getWidth(), other.getWidth()) != 0) {
            return false;
        }
        if (Float.compare(this.getLineSpacing(), other.getLineSpacing()) != 0) {
            return false;
        }
        if (Float.compare(this.getHeight(), other.getHeight()) != 0) {
            return false;
        }
        Log this$log = this.getLog();
        Log other$log = other.getLog();
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        PDFont this$font = this.getFont();
        PDFont other$font = other.getFont();
        if (this$font == null ? other$font != null : !this$font.equals(other$font)) {
            return false;
        }
        Color this$color = this.getColor();
        Color other$color = other.getColor();
        return !(this$color == null ? other$color != null : !((Object)this$color).equals(other$color));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestStackTrace;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFontSize();
        result = result * 59 + Float.floatToIntBits(this.getPadding());
        result = result * 59 + Float.floatToIntBits(this.getWidth());
        result = result * 59 + Float.floatToIntBits(this.getLineSpacing());
        result = result * 59 + Float.floatToIntBits(this.getHeight());
        Log $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        PDFont $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        Color $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : ((Object)$color).hashCode());
        return result;
    }

    public String toString() {
        return "TestStackTrace(log=" + this.getLog() + ", font=" + this.getFont() + ", fontSize=" + this.getFontSize() + ", padding=" + this.getPadding() + ", width=" + this.getWidth() + ", lineSpacing=" + this.getLineSpacing() + ", height=" + this.getHeight() + ", color=" + this.getColor() + ")";
    }

    public static class TestStackTraceBuilder {
        private Log log;
        private PDFont font;
        private int fontSize;
        private float padding;
        private float width;
        private boolean lineSpacing$set;
        private float lineSpacing$value;
        private float height;
        private boolean color$set;
        private Color color$value;

        TestStackTraceBuilder() {
        }

        public TestStackTraceBuilder log(Log log) {
            this.log = log;
            return this;
        }

        public TestStackTraceBuilder font(PDFont font) {
            this.font = font;
            return this;
        }

        public TestStackTraceBuilder fontSize(int fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public TestStackTraceBuilder padding(float padding) {
            this.padding = padding;
            return this;
        }

        public TestStackTraceBuilder width(float width) {
            this.width = width;
            return this;
        }

        public TestStackTraceBuilder lineSpacing(float lineSpacing) {
            this.lineSpacing$value = lineSpacing;
            this.lineSpacing$set = true;
            return this;
        }

        public TestStackTraceBuilder height(float height) {
            this.height = height;
            return this;
        }

        public TestStackTraceBuilder color(Color color) {
            this.color$value = color;
            this.color$set = true;
            return this;
        }

        public TestStackTrace build() {
            float lineSpacing$value = this.lineSpacing$value;
            if (!this.lineSpacing$set) {
                lineSpacing$value = TestStackTrace.$default$lineSpacing();
            }
            Color color$value = this.color$value;
            if (!this.color$set) {
                color$value = TestStackTrace.$default$color();
            }
            return new TestStackTrace(this.log, this.font, this.fontSize, this.padding, this.width, lineSpacing$value, this.height, color$value);
        }

        public String toString() {
            return "TestStackTrace.TestStackTraceBuilder(log=" + this.log + ", font=" + this.font + ", fontSize=" + this.fontSize + ", padding=" + this.padding + ", width=" + this.width + ", lineSpacing$value=" + this.lineSpacing$value + ", height=" + this.height + ", color$value=" + this.color$value + ")";
        }
    }
}

