/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.tests;

import com.aventstack.extentreports.model.Media;
import com.aventstack.extentreports.model.service.MediaService;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.vandeseer.easytable.structure.cell.ImageCell;

public class TestMedia {
    private Media media;
    private PDDocument document;
    private float width;
    private float height;
    private float padding;
    private static PDImageXObject imageNotFound = null;

    public ImageCell createImageCell() {
        PDImageXObject image = null;
        try {
            if (imageNotFound == null) {
                imageNotFound = PDImageXObject.createFromFile((String)"src/main/resources/not-found-image.png", (PDDocument)this.document);
            }
            image = MediaService.isBase64((Media)this.media) ? imageNotFound : PDImageXObject.createFromFile((String)this.media.getPath(), (PDDocument)this.document);
        }
        catch (IOException e) {
            image = imageNotFound;
        }
        return ((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)ImageCell.builder().image(image).width(this.width)).padding(this.padding)).maxHeight(this.height).build();
    }

    TestMedia(Media media, PDDocument document, float width, float height, float padding) {
        this.media = media;
        this.document = document;
        this.width = width;
        this.height = height;
        this.padding = padding;
    }

    public static TestMediaBuilder builder() {
        return new TestMediaBuilder();
    }

    public Media getMedia() {
        return this.media;
    }

    public PDDocument getDocument() {
        return this.document;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float getPadding() {
        return this.padding;
    }

    public void setMedia(Media media) {
        this.media = media;
    }

    public void setDocument(PDDocument document) {
        this.document = document;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public void setPadding(float padding) {
        this.padding = padding;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestMedia)) {
            return false;
        }
        TestMedia other = (TestMedia)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getWidth(), other.getWidth()) != 0) {
            return false;
        }
        if (Float.compare(this.getHeight(), other.getHeight()) != 0) {
            return false;
        }
        if (Float.compare(this.getPadding(), other.getPadding()) != 0) {
            return false;
        }
        Media this$media = this.getMedia();
        Media other$media = other.getMedia();
        if (this$media == null ? other$media != null : !this$media.equals(other$media)) {
            return false;
        }
        PDDocument this$document = this.getDocument();
        PDDocument other$document = other.getDocument();
        return !(this$document == null ? other$document != null : !this$document.equals(other$document));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestMedia;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getWidth());
        result = result * 59 + Float.floatToIntBits(this.getHeight());
        result = result * 59 + Float.floatToIntBits(this.getPadding());
        Media $media = this.getMedia();
        result = result * 59 + ($media == null ? 43 : $media.hashCode());
        PDDocument $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : $document.hashCode());
        return result;
    }

    public String toString() {
        return "TestMedia(media=" + this.getMedia() + ", document=" + this.getDocument() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", padding=" + this.getPadding() + ")";
    }

    public static class TestMediaBuilder {
        private Media media;
        private PDDocument document;
        private float width;
        private float height;
        private float padding;

        TestMediaBuilder() {
        }

        public TestMediaBuilder media(Media media) {
            this.media = media;
            return this;
        }

        public TestMediaBuilder document(PDDocument document) {
            this.document = document;
            return this;
        }

        public TestMediaBuilder width(float width) {
            this.width = width;
            return this;
        }

        public TestMediaBuilder height(float height) {
            this.height = height;
            return this;
        }

        public TestMediaBuilder padding(float padding) {
            this.padding = padding;
            return this;
        }

        public TestMedia build() {
            return new TestMedia(this.media, this.document, this.width, this.height, this.padding);
        }

        public String toString() {
            return "TestMedia.TestMediaBuilder(media=" + this.media + ", document=" + this.document + ", width=" + this.width + ", height=" + this.height + ", padding=" + this.padding + ")";
        }
    }
}

