/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.tests;

import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.Test;
import java.awt.Color;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.annotation.Annotation;
import tech.grasshopper.pdf.structure.cell.TableWithinTableCell;
import tech.grasshopper.pdf.structure.cell.TextLabelCell;
import tech.grasshopper.pdf.structure.cell.TextLinkCell;
import tech.grasshopper.reporter.annotation.AnnotationStore;
import tech.grasshopper.reporter.font.ReportFont;
import tech.grasshopper.reporter.optimizer.TextSanitizer;
import tech.grasshopper.reporter.structure.Display;
import tech.grasshopper.reporter.structure.TableCreator;
import tech.grasshopper.reporter.tests.TestIndent;
import tech.grasshopper.reporter.tests.TestMedia;
import tech.grasshopper.reporter.tests.TestStackTrace;
import tech.grasshopper.reporter.tests.markup.TestMarkup;
import tech.grasshopper.reporter.util.DateUtil;

public class TestLogsDisplay
extends Display
implements TestIndent {
    public static final float LOGS_HEADER_HEIGHT = 20.0f;
    public static final float LOGS_ROW_HEIGHT = 20.0f;
    public static final float LOGS_MEDIA_HEIGHT = 100.0f;
    public static final float LOGS_MEDIA_WIDTH = 100.0f;
    private static final int LOGS_HEADER_FONT_SIZE = 11;
    private static final float PADDING = 5.0f;
    private static final float LOGS_STATUS_WIDTH = 50.0f;
    private static final float LOGS_TIMESTAMP_WIDTH = 70.0f;
    private static final float LOGS_DETAILS_WIDTH = 380.0f;
    private static final float LOGS_DETAILS_HEIGHT = 15.0f;
    private static final float LOGS_MEDIA_PLUS_WIDTH = 15.0f;
    private static final float BORDER_WIDTH = 1.0f;
    private static final int LOGS_TABLE_CONTENT_FONT_SIZE = 10;
    private static final PDFont LOGS_TABLE_CONTENT_FONT = ReportFont.REGULAR_FONT;
    private static final int LOGS_STACK_TRACE_TABLE_CONTENT_FONT_SIZE = 11;
    private static final PDFont LOGS_STACK_TRACE_TABLE_CONTENT_FONT = ReportFont.BOLD_FONT;
    private static final float LOGS_TABLE_CONTENT_MULTILINE_SPACING = 1.0f;
    private static final float GAP_HEIGHT = 15.0f;
    protected Test test;
    private Table.TableBuilder tableBuilder;
    protected final TextSanitizer textSanitizer = TextSanitizer.builder().font(LOGS_TABLE_CONTENT_FONT).build();
    private AnnotationStore annotations;

    @Override
    public void display() {
        if (this.test.hasLog()) {
            this.xlocation += (float)(this.calculateIndent(this.test.getLevel(), this.config.getTestMaxIndentLevel()) * 20);
            this.createTableBuilder();
            this.createHeaderRow();
            this.createLogRows();
            this.drawTable();
        }
    }

    private void createTableBuilder() {
        this.tableBuilder = Table.builder().addColumnsOfWidth(new float[]{50.0f, 70.0f, 380.0f - (float)(this.test.getLevel() * 20)}).padding(5.0f).borderColor(Color.LIGHT_GRAY).borderWidth(1.0f).horizontalAlignment(HorizontalAlignment.LEFT).verticalAlignment(VerticalAlignment.TOP);
    }

    private void createHeaderRow() {
        this.tableBuilder.addRow(Row.builder().height(Float.valueOf(20.0f)).font(ReportFont.ITALIC_FONT).fontSize(Integer.valueOf(11)).add((AbstractCell)TextCell.builder().text("Status").build()).add((AbstractCell)TextCell.builder().text("Timestamp").build()).add((AbstractCell)TextCell.builder().text("Log Details").build()).build());
    }

    private void createLogRows() {
        this.test.getLogs().forEach(l -> {
            TextCell detailCell = ((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(this.textSanitizer.sanitizeText(l.getDetails())).textColor(this.config.statusColor(l.getStatus()))).lineSpacing(1.0f)).build();
            if (l.hasMedia()) {
                detailCell = this.createMediaCell((Log)l);
            } else if (l.hasException()) {
                detailCell = TestStackTrace.builder().log((Log)l).font(LOGS_STACK_TRACE_TABLE_CONTENT_FONT).color(this.config.getTestExceptionColor()).width(380.0f - (float)(this.test.getLevel() * 20) - 10.0f).height(15.0f).fontSize(11).padding(5.0f).build().createStackTraceCell();
            } else if (TestMarkup.isMarkup(l.getDetails())) {
                detailCell = TestMarkup.builder().log((Log)l).width(370.0f).config(this.config).build().createMarkupCell();
            }
            Row row = Row.builder().font(LOGS_TABLE_CONTENT_FONT).fontSize(Integer.valueOf(10)).wordBreak(Boolean.valueOf(true)).padding(5.0f).add((AbstractCell)((TextLabelCell.TextLabelCellBuilder)TextLabelCell.builder().text(l.getStatus().toString())).labelColor(this.config.statusColor(l.getStatus())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(DateUtil.formatTimeAMPM(DateUtil.convertToLocalDateTimeFromDate(l.getTimestamp()))).textColor(this.config.getTestTimeStampColor())).build()).add((AbstractCell)detailCell).build();
            this.tableBuilder.addRow(row);
        });
    }

    private AbstractCell createMediaCell(Log log) {
        if (this.config.isDisplayExpandedMedia()) {
            Table.TableBuilder tableBuilder = Table.builder().addColumnsOfWidth(new float[]{15.0f, 365.0f}).padding(0.0f);
            Annotation annotation = Annotation.builder().id(this.test.getId()).build();
            this.annotations.addTestMediaAnnotation(annotation);
            tableBuilder.addRow(Row.builder().add((AbstractCell)((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)TextLinkCell.builder().text("+")).annotation(annotation).font(ReportFont.REGULAR_FONT)).fontSize(Integer.valueOf(15))).textColor(Color.RED)).showLine(false).verticalAlignment(VerticalAlignment.TOP)).horizontalAlignment(HorizontalAlignment.CENTER)).build()).add((AbstractCell)TestMedia.builder().media(log.getMedia()).document(this.document).width(365.0f).height(100.0f).build().createImageCell()).build());
            return ((TableWithinTableCell.TableWithinTableCellBuilder)TableWithinTableCell.builder().table(tableBuilder.build()).width(365.0f)).build();
        }
        return TestMedia.builder().media(log.getMedia()).document(this.document).width(100.0f).height(100.0f).padding(5.0f).build().createImageCell();
    }

    private void drawTable() {
        TableCreator table = TableCreator.builder().tableBuilder(this.tableBuilder).document(this.document).startX(this.xlocation).startY(this.ylocation).repeatRows(1).splitRow(true).build();
        table.displayTable();
        this.ylocation = table.getFinalY() - 15.0f;
    }

    protected TestLogsDisplay(TestLogsDisplayBuilder<?, ?> b) {
        super(b);
        this.test = ((TestLogsDisplayBuilder)b).test;
        this.tableBuilder = ((TestLogsDisplayBuilder)b).tableBuilder;
        this.annotations = ((TestLogsDisplayBuilder)b).annotations;
    }

    public static TestLogsDisplayBuilder<?, ?> builder() {
        return new TestLogsDisplayBuilderImpl();
    }

    public Test getTest() {
        return this.test;
    }

    public Table.TableBuilder getTableBuilder() {
        return this.tableBuilder;
    }

    public TextSanitizer getTextSanitizer() {
        return this.textSanitizer;
    }

    public AnnotationStore getAnnotations() {
        return this.annotations;
    }

    public void setTest(Test test) {
        this.test = test;
    }

    public void setTableBuilder(Table.TableBuilder tableBuilder) {
        this.tableBuilder = tableBuilder;
    }

    public void setAnnotations(AnnotationStore annotations) {
        this.annotations = annotations;
    }

    @Override
    public String toString() {
        return "TestLogsDisplay(test=" + this.getTest() + ", tableBuilder=" + this.getTableBuilder() + ", textSanitizer=" + this.getTextSanitizer() + ", annotations=" + this.getAnnotations() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestLogsDisplay)) {
            return false;
        }
        TestLogsDisplay other = (TestLogsDisplay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Test this$test = this.getTest();
        Test other$test = other.getTest();
        if (this$test == null ? other$test != null : !this$test.equals(other$test)) {
            return false;
        }
        Table.TableBuilder this$tableBuilder = this.getTableBuilder();
        Table.TableBuilder other$tableBuilder = other.getTableBuilder();
        if (this$tableBuilder == null ? other$tableBuilder != null : !this$tableBuilder.equals(other$tableBuilder)) {
            return false;
        }
        TextSanitizer this$textSanitizer = this.getTextSanitizer();
        TextSanitizer other$textSanitizer = other.getTextSanitizer();
        if (this$textSanitizer == null ? other$textSanitizer != null : !((Object)this$textSanitizer).equals(other$textSanitizer)) {
            return false;
        }
        AnnotationStore this$annotations = this.getAnnotations();
        AnnotationStore other$annotations = other.getAnnotations();
        return !(this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TestLogsDisplay;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Test $test = this.getTest();
        result = result * 59 + ($test == null ? 43 : $test.hashCode());
        Table.TableBuilder $tableBuilder = this.getTableBuilder();
        result = result * 59 + ($tableBuilder == null ? 43 : $tableBuilder.hashCode());
        TextSanitizer $textSanitizer = this.getTextSanitizer();
        result = result * 59 + ($textSanitizer == null ? 43 : ((Object)$textSanitizer).hashCode());
        AnnotationStore $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        return result;
    }

    private static final class TestLogsDisplayBuilderImpl
    extends TestLogsDisplayBuilder<TestLogsDisplay, TestLogsDisplayBuilderImpl> {
        private TestLogsDisplayBuilderImpl() {
        }

        @Override
        protected TestLogsDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public TestLogsDisplay build() {
            return new TestLogsDisplay(this);
        }
    }

    public static abstract class TestLogsDisplayBuilder<C extends TestLogsDisplay, B extends TestLogsDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private Test test;
        private Table.TableBuilder tableBuilder;
        private AnnotationStore annotations;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B test(Test test) {
            this.test = test;
            return (B)this.self();
        }

        public B tableBuilder(Table.TableBuilder tableBuilder) {
            this.tableBuilder = tableBuilder;
            return (B)this.self();
        }

        public B annotations(AnnotationStore annotations) {
            this.annotations = annotations;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TestLogsDisplay.TestLogsDisplayBuilder(super=" + super.toString() + ", test=" + this.test + ", tableBuilder=" + this.tableBuilder + ", annotations=" + this.annotations + ")";
        }
    }
}

