/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.tests;

import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.Test;
import java.awt.Color;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.structure.cell.TextLabelCell;
import tech.grasshopper.reporter.font.ReportFont;
import tech.grasshopper.reporter.structure.Display;
import tech.grasshopper.reporter.structure.TableCreator;
import tech.grasshopper.reporter.tests.TestIndent;
import tech.grasshopper.reporter.tests.markup.TestMarkup;

public class TestGeneratedLogDisplay
extends Display
implements TestIndent {
    public static final float LOGS_HEADER_HEIGHT = 20.0f;
    public static final float LOGS_ROW_HEIGHT = 20.0f;
    private static final int LOGS_HEADER_FONT_SIZE = 11;
    private static final float PADDING = 5.0f;
    private static final float LOGS_STATUS_WIDTH = 50.0f;
    private static final float LOGS_DETAILS_WIDTH = 450.0f;
    private static final float BORDER_WIDTH = 1.0f;
    private static final float GAP_HEIGHT = 10.0f;
    private static final int LOGS_TABLE_CONTENT_FONT_SIZE = 10;
    private static final PDFont LOGS_TABLE_CONTENT_FONT = ReportFont.REGULAR_FONT;
    protected Test test;
    private Table.TableBuilder tableBuilder;

    @Override
    public void display() {
        if (!this.test.getGeneratedLog().isEmpty()) {
            this.xlocation += (float)(this.calculateIndent(this.test.getLevel(), this.config.getTestMaxIndentLevel()) * 20);
            this.createTableBuilder();
            this.createHeaderRow();
            this.createLogRows();
            this.drawTable();
        }
    }

    private void createTableBuilder() {
        this.tableBuilder = Table.builder().addColumnsOfWidth(new float[]{50.0f, 450.0f - (float)(this.test.getLevel() * 20)}).padding(5.0f).borderColor(Color.LIGHT_GRAY).borderWidth(1.0f).horizontalAlignment(HorizontalAlignment.LEFT).verticalAlignment(VerticalAlignment.TOP);
    }

    private void createHeaderRow() {
        this.tableBuilder.addRow(Row.builder().height(Float.valueOf(20.0f)).font(ReportFont.ITALIC_FONT).fontSize(Integer.valueOf(11)).add((AbstractCell)TextCell.builder().text("Status").build()).add((AbstractCell)TextCell.builder().text("Generated Log Details").build()).build());
    }

    private void createLogRows() {
        this.test.getGeneratedLog().forEach(l -> {
            AbstractCell detailCell = TestMarkup.builder().log((Log)l).width(440.0f).config(this.config).build().createMarkupCell();
            Row row = Row.builder().font(LOGS_TABLE_CONTENT_FONT).fontSize(Integer.valueOf(10)).wordBreak(Boolean.valueOf(true)).padding(5.0f).add((AbstractCell)((TextLabelCell.TextLabelCellBuilder)TextLabelCell.builder().text(l.getStatus().toString())).labelColor(this.config.statusColor(l.getStatus())).build()).add(detailCell).build();
            this.tableBuilder.addRow(row);
        });
    }

    private void drawTable() {
        TableCreator table = TableCreator.builder().tableBuilder(this.tableBuilder).document(this.document).startX(this.xlocation).startY(this.ylocation).repeatRows(1).splitRow(true).build();
        table.displayTable();
        this.ylocation = table.getFinalY() - 10.0f;
    }

    protected TestGeneratedLogDisplay(TestGeneratedLogDisplayBuilder<?, ?> b) {
        super(b);
        this.test = ((TestGeneratedLogDisplayBuilder)b).test;
        this.tableBuilder = ((TestGeneratedLogDisplayBuilder)b).tableBuilder;
    }

    public static TestGeneratedLogDisplayBuilder<?, ?> builder() {
        return new TestGeneratedLogDisplayBuilderImpl();
    }

    public Test getTest() {
        return this.test;
    }

    public Table.TableBuilder getTableBuilder() {
        return this.tableBuilder;
    }

    public void setTest(Test test) {
        this.test = test;
    }

    public void setTableBuilder(Table.TableBuilder tableBuilder) {
        this.tableBuilder = tableBuilder;
    }

    @Override
    public String toString() {
        return "TestGeneratedLogDisplay(test=" + this.getTest() + ", tableBuilder=" + this.getTableBuilder() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestGeneratedLogDisplay)) {
            return false;
        }
        TestGeneratedLogDisplay other = (TestGeneratedLogDisplay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Test this$test = this.getTest();
        Test other$test = other.getTest();
        if (this$test == null ? other$test != null : !this$test.equals(other$test)) {
            return false;
        }
        Table.TableBuilder this$tableBuilder = this.getTableBuilder();
        Table.TableBuilder other$tableBuilder = other.getTableBuilder();
        return !(this$tableBuilder == null ? other$tableBuilder != null : !this$tableBuilder.equals(other$tableBuilder));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TestGeneratedLogDisplay;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Test $test = this.getTest();
        result = result * 59 + ($test == null ? 43 : $test.hashCode());
        Table.TableBuilder $tableBuilder = this.getTableBuilder();
        result = result * 59 + ($tableBuilder == null ? 43 : $tableBuilder.hashCode());
        return result;
    }

    private static final class TestGeneratedLogDisplayBuilderImpl
    extends TestGeneratedLogDisplayBuilder<TestGeneratedLogDisplay, TestGeneratedLogDisplayBuilderImpl> {
        private TestGeneratedLogDisplayBuilderImpl() {
        }

        @Override
        protected TestGeneratedLogDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public TestGeneratedLogDisplay build() {
            return new TestGeneratedLogDisplay(this);
        }
    }

    public static abstract class TestGeneratedLogDisplayBuilder<C extends TestGeneratedLogDisplay, B extends TestGeneratedLogDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private Test test;
        private Table.TableBuilder tableBuilder;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B test(Test test) {
            this.test = test;
            return (B)this.self();
        }

        public B tableBuilder(Table.TableBuilder tableBuilder) {
            this.tableBuilder = tableBuilder;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TestGeneratedLogDisplay.TestGeneratedLogDisplayBuilder(super=" + super.toString() + ", test=" + this.test + ", tableBuilder=" + this.tableBuilder + ")";
        }
    }
}

