/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.tests;

import com.aventstack.extentreports.model.NamedAttribute;
import com.aventstack.extentreports.model.Test;
import java.time.LocalDateTime;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import org.vandeseer.easytable.structure.cell.paragraph.ParagraphCell;
import org.vandeseer.easytable.structure.cell.paragraph.StyledText;
import tech.grasshopper.reporter.context.AttributeType;
import tech.grasshopper.reporter.destination.Destination;
import tech.grasshopper.reporter.destination.DestinationAware;
import tech.grasshopper.reporter.font.ReportFont;
import tech.grasshopper.reporter.optimizer.TextSanitizer;
import tech.grasshopper.reporter.structure.Display;
import tech.grasshopper.reporter.structure.TableCreator;
import tech.grasshopper.reporter.tests.TestIndent;
import tech.grasshopper.reporter.util.DateUtil;

public class TestBasicDetailsDisplay
extends Display
implements TestIndent,
DestinationAware {
    private static final PDFont CONTENT_FONT = ReportFont.BOLD_ITALIC_FONT;
    private static final int NAME_FONT_SIZE = 15;
    private static final int TIMES_FONT_SIZE = 12;
    private static final int ATTRIBUTE_FONT_SIZE = 12;
    private static final float PADDING = 5.0f;
    private static final float WIDTH = 500.0f;
    private static final float NAME_HEIGHT = 20.0f;
    private static final float TIMES_HEIGHT = 20.0f;
    private static final float ATTRIBUTE_HEIGHT = 20.0f;
    private static final float GAP_HEIGHT = 5.0f;
    private static final float BORDER_WIDTH = 0.0f;
    private static final float MULTI_LINE_SPACING = 1.0f;
    protected Test test;
    private int numberOfRowsToRepeat;
    private Table.TableBuilder tableBuilder;
    private int destinationY;
    protected final TextSanitizer textSanitizer = TextSanitizer.builder().font(CONTENT_FONT).build();

    @Override
    public void display() {
        this.xlocation += (float)(this.calculateIndent(this.test.getLevel(), this.config.getTestMaxIndentLevel()) * 20);
        this.createTableBuilder();
        this.createNameRow();
        this.createDurationRow();
        this.createAttributesRow();
        this.drawTable();
    }

    private void createTableBuilder() {
        this.tableBuilder = Table.builder().addColumnsOfWidth(new float[]{500.0f}).padding(5.0f).borderWidth(0.0f).font(ReportFont.BOLD_ITALIC_FONT).horizontalAlignment(HorizontalAlignment.LEFT).verticalAlignment(VerticalAlignment.MIDDLE);
    }

    private void createNameRow() {
        this.tableBuilder.addRow(Row.builder().add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().minHeight(20.0f)).fontSize(Integer.valueOf(15))).text(this.textSanitizer.sanitizeText(this.test.getName())).wordBreak(Boolean.valueOf(true))).lineSpacing(1.0f)).textColor(this.config.getTestNameColor())).build()).build());
    }

    private void createDurationRow() {
        this.tableBuilder.addRow(Row.builder().add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().minHeight(20.0f)).fontSize(Integer.valueOf(12))).text(this.testDuration()).textColor(this.config.getTestTimesColor())).build()).build());
    }

    private String testDuration() {
        LocalDateTime start = DateUtil.convertToLocalDateTimeFromDate(this.test.getStartTime());
        LocalDateTime end = DateUtil.convertToLocalDateTimeFromDate(this.test.getEndTime());
        String duration = "/ " + DateUtil.formatDateTimeWithMillis(start) + " / " + DateUtil.formatDateTimeWithMillis(end) + " / " + DateUtil.durationValue(start, end) + " /";
        if (this.test.getLevel() > 0) {
            duration = " / " + DateUtil.durationValue(start, end) + " /";
        }
        return duration;
    }

    private void createAttributesRow() {
        if (this.test.getCategorySet().isEmpty() && this.test.getAuthorSet().isEmpty() && this.test.getDeviceSet().isEmpty()) {
            return;
        }
        ParagraphCell.Paragraph.ParagraphBuilder paraBuilder = ParagraphCell.Paragraph.builder();
        this.createAttributeText(this.test.getCategorySet(), AttributeType.CATEGORY, paraBuilder);
        this.createAttributeText(this.test.getAuthorSet(), AttributeType.AUTHOR, paraBuilder);
        this.createAttributeText(this.test.getDeviceSet(), AttributeType.DEVICE, paraBuilder);
        this.tableBuilder.addRow(Row.builder().fontSize(Integer.valueOf(12)).add((AbstractCell)((ParagraphCell.ParagraphCellBuilder)ParagraphCell.builder().paragraph(paraBuilder.build()).minHeight(20.0f)).lineSpacing(1.0f).build()).build());
    }

    private void createAttributeText(Set<? extends NamedAttribute> attributes, AttributeType type, ParagraphCell.Paragraph.ParagraphBuilder paraBuilder) {
        if (!attributes.isEmpty()) {
            this.numberOfRowsToRepeat = 3;
            String atts = attributes.stream().map(a -> this.textSanitizer.sanitizeText(a.getName())).collect(Collectors.joining(" / ", "/ ", " /"));
            paraBuilder.append(StyledText.builder().text(atts).color(this.config.attributeHeaderColor(type)).build());
        }
    }

    private void drawTable() {
        PDPage initialPage = this.document.getPage(this.document.getNumberOfPages() - 1);
        this.destinationY = (int)this.ylocation;
        TableCreator table = TableCreator.builder().tableBuilder(this.tableBuilder).document(this.document).startX(this.xlocation).startY(this.ylocation).repeatRows(this.numberOfRowsToRepeat).build();
        table.displayTable();
        this.ylocation = table.getFinalY() - 5.0f;
        this.page = table.getTableStartPage();
        if (!initialPage.equals((Object)this.page)) {
            this.destinationY = 790;
        }
    }

    @Override
    public Destination createDestination() {
        return Destination.builder().id(this.test.getId()).name(this.textSanitizer.sanitizeText(this.test.getName())).yCoord(this.destinationY).page(this.page).build();
    }

    private static int $default$numberOfRowsToRepeat() {
        return 2;
    }

    protected TestBasicDetailsDisplay(TestBasicDetailsDisplayBuilder<?, ?> b) {
        super(b);
        this.test = ((TestBasicDetailsDisplayBuilder)b).test;
        this.numberOfRowsToRepeat = ((TestBasicDetailsDisplayBuilder)b).numberOfRowsToRepeat$set ? ((TestBasicDetailsDisplayBuilder)b).numberOfRowsToRepeat$value : TestBasicDetailsDisplay.$default$numberOfRowsToRepeat();
        this.tableBuilder = ((TestBasicDetailsDisplayBuilder)b).tableBuilder;
        this.destinationY = ((TestBasicDetailsDisplayBuilder)b).destinationY;
    }

    public static TestBasicDetailsDisplayBuilder<?, ?> builder() {
        return new TestBasicDetailsDisplayBuilderImpl();
    }

    public Test getTest() {
        return this.test;
    }

    public int getNumberOfRowsToRepeat() {
        return this.numberOfRowsToRepeat;
    }

    public Table.TableBuilder getTableBuilder() {
        return this.tableBuilder;
    }

    public int getDestinationY() {
        return this.destinationY;
    }

    public TextSanitizer getTextSanitizer() {
        return this.textSanitizer;
    }

    public void setTest(Test test) {
        this.test = test;
    }

    public void setNumberOfRowsToRepeat(int numberOfRowsToRepeat) {
        this.numberOfRowsToRepeat = numberOfRowsToRepeat;
    }

    public void setTableBuilder(Table.TableBuilder tableBuilder) {
        this.tableBuilder = tableBuilder;
    }

    public void setDestinationY(int destinationY) {
        this.destinationY = destinationY;
    }

    @Override
    public String toString() {
        return "TestBasicDetailsDisplay(test=" + this.getTest() + ", numberOfRowsToRepeat=" + this.getNumberOfRowsToRepeat() + ", tableBuilder=" + this.getTableBuilder() + ", destinationY=" + this.getDestinationY() + ", textSanitizer=" + this.getTextSanitizer() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestBasicDetailsDisplay)) {
            return false;
        }
        TestBasicDetailsDisplay other = (TestBasicDetailsDisplay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNumberOfRowsToRepeat() != other.getNumberOfRowsToRepeat()) {
            return false;
        }
        if (this.getDestinationY() != other.getDestinationY()) {
            return false;
        }
        Test this$test = this.getTest();
        Test other$test = other.getTest();
        if (this$test == null ? other$test != null : !this$test.equals(other$test)) {
            return false;
        }
        Table.TableBuilder this$tableBuilder = this.getTableBuilder();
        Table.TableBuilder other$tableBuilder = other.getTableBuilder();
        if (this$tableBuilder == null ? other$tableBuilder != null : !this$tableBuilder.equals(other$tableBuilder)) {
            return false;
        }
        TextSanitizer this$textSanitizer = this.getTextSanitizer();
        TextSanitizer other$textSanitizer = other.getTextSanitizer();
        return !(this$textSanitizer == null ? other$textSanitizer != null : !((Object)this$textSanitizer).equals(other$textSanitizer));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TestBasicDetailsDisplay;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNumberOfRowsToRepeat();
        result = result * 59 + this.getDestinationY();
        Test $test = this.getTest();
        result = result * 59 + ($test == null ? 43 : $test.hashCode());
        Table.TableBuilder $tableBuilder = this.getTableBuilder();
        result = result * 59 + ($tableBuilder == null ? 43 : $tableBuilder.hashCode());
        TextSanitizer $textSanitizer = this.getTextSanitizer();
        result = result * 59 + ($textSanitizer == null ? 43 : ((Object)$textSanitizer).hashCode());
        return result;
    }

    private static final class TestBasicDetailsDisplayBuilderImpl
    extends TestBasicDetailsDisplayBuilder<TestBasicDetailsDisplay, TestBasicDetailsDisplayBuilderImpl> {
        private TestBasicDetailsDisplayBuilderImpl() {
        }

        @Override
        protected TestBasicDetailsDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public TestBasicDetailsDisplay build() {
            return new TestBasicDetailsDisplay(this);
        }
    }

    public static abstract class TestBasicDetailsDisplayBuilder<C extends TestBasicDetailsDisplay, B extends TestBasicDetailsDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private Test test;
        private boolean numberOfRowsToRepeat$set;
        private int numberOfRowsToRepeat$value;
        private Table.TableBuilder tableBuilder;
        private int destinationY;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B test(Test test) {
            this.test = test;
            return (B)this.self();
        }

        public B numberOfRowsToRepeat(int numberOfRowsToRepeat) {
            this.numberOfRowsToRepeat$value = numberOfRowsToRepeat;
            this.numberOfRowsToRepeat$set = true;
            return (B)this.self();
        }

        public B tableBuilder(Table.TableBuilder tableBuilder) {
            this.tableBuilder = tableBuilder;
            return (B)this.self();
        }

        public B destinationY(int destinationY) {
            this.destinationY = destinationY;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TestBasicDetailsDisplay.TestBasicDetailsDisplayBuilder(super=" + super.toString() + ", test=" + this.test + ", numberOfRowsToRepeat$value=" + this.numberOfRowsToRepeat$value + ", tableBuilder=" + this.tableBuilder + ", destinationY=" + this.destinationY + ")";
        }
    }
}

