/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.structure;

import com.aventstack.extentreports.model.Report;
import lombok.NonNull;
import org.apache.pdfbox.pdmodel.PDDocument;
import tech.grasshopper.reporter.annotation.AnnotationStore;
import tech.grasshopper.reporter.config.ExtentPDFReporterConfig;
import tech.grasshopper.reporter.destination.Destination;
import tech.grasshopper.reporter.header.PageHeader;
import tech.grasshopper.reporter.structure.PageCreator;

public abstract class Section {
    @NonNull
    protected PDDocument document;
    protected Destination.DestinationStore destinations;
    protected AnnotationStore annotations;
    protected ExtentPDFReporterConfig config;
    @NonNull
    protected Report report;
    protected PageHeader pageHeader;

    public abstract void createSection();

    protected void createPage() {
        PageCreator.createPotraitPageAndAddToDocument(this.document);
    }

    public void pageHeaderDetails() {
        this.pageHeader.addSectionPageData(this.getSectionTitle(), this.document.getNumberOfPages());
    }

    public abstract String getSectionTitle();

    protected Section(SectionBuilder<?, ?> b) {
        this.document = ((SectionBuilder)b).document;
        if (this.document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        this.destinations = ((SectionBuilder)b).destinations;
        this.annotations = ((SectionBuilder)b).annotations;
        this.config = ((SectionBuilder)b).config;
        this.report = ((SectionBuilder)b).report;
        if (this.report == null) {
            throw new NullPointerException("report is marked non-null but is null");
        }
        this.pageHeader = ((SectionBuilder)b).pageHeader;
    }

    @NonNull
    public PDDocument getDocument() {
        return this.document;
    }

    public Destination.DestinationStore getDestinations() {
        return this.destinations;
    }

    public AnnotationStore getAnnotations() {
        return this.annotations;
    }

    public ExtentPDFReporterConfig getConfig() {
        return this.config;
    }

    @NonNull
    public Report getReport() {
        return this.report;
    }

    public PageHeader getPageHeader() {
        return this.pageHeader;
    }

    public void setDocument(@NonNull PDDocument document) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        this.document = document;
    }

    public void setDestinations(Destination.DestinationStore destinations) {
        this.destinations = destinations;
    }

    public void setAnnotations(AnnotationStore annotations) {
        this.annotations = annotations;
    }

    public void setConfig(ExtentPDFReporterConfig config) {
        this.config = config;
    }

    public void setReport(@NonNull Report report) {
        if (report == null) {
            throw new NullPointerException("report is marked non-null but is null");
        }
        this.report = report;
    }

    public void setPageHeader(PageHeader pageHeader) {
        this.pageHeader = pageHeader;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Section)) {
            return false;
        }
        Section other = (Section)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PDDocument this$document = this.getDocument();
        PDDocument other$document = other.getDocument();
        if (this$document == null ? other$document != null : !this$document.equals(other$document)) {
            return false;
        }
        Destination.DestinationStore this$destinations = this.getDestinations();
        Destination.DestinationStore other$destinations = other.getDestinations();
        if (this$destinations == null ? other$destinations != null : !((Object)this$destinations).equals(other$destinations)) {
            return false;
        }
        AnnotationStore this$annotations = this.getAnnotations();
        AnnotationStore other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        ExtentPDFReporterConfig this$config = this.getConfig();
        ExtentPDFReporterConfig other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)((Object)this$config)).equals((Object)other$config)) {
            return false;
        }
        Report this$report = this.getReport();
        Report other$report = other.getReport();
        if (this$report == null ? other$report != null : !this$report.equals(other$report)) {
            return false;
        }
        PageHeader this$pageHeader = this.getPageHeader();
        PageHeader other$pageHeader = other.getPageHeader();
        return !(this$pageHeader == null ? other$pageHeader != null : !this$pageHeader.equals(other$pageHeader));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Section;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PDDocument $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : $document.hashCode());
        Destination.DestinationStore $destinations = this.getDestinations();
        result = result * 59 + ($destinations == null ? 43 : ((Object)$destinations).hashCode());
        AnnotationStore $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        ExtentPDFReporterConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)((Object)$config)).hashCode());
        Report $report = this.getReport();
        result = result * 59 + ($report == null ? 43 : $report.hashCode());
        PageHeader $pageHeader = this.getPageHeader();
        result = result * 59 + ($pageHeader == null ? 43 : $pageHeader.hashCode());
        return result;
    }

    public String toString() {
        return "Section(document=" + this.getDocument() + ", destinations=" + this.getDestinations() + ", annotations=" + this.getAnnotations() + ", config=" + (Object)((Object)this.getConfig()) + ", report=" + this.getReport() + ", pageHeader=" + this.getPageHeader() + ")";
    }

    public static abstract class SectionBuilder<C extends Section, B extends SectionBuilder<C, B>> {
        private PDDocument document;
        private Destination.DestinationStore destinations;
        private AnnotationStore annotations;
        private ExtentPDFReporterConfig config;
        private Report report;
        private PageHeader pageHeader;

        protected abstract B self();

        public abstract C build();

        public B document(@NonNull PDDocument document) {
            if (document == null) {
                throw new NullPointerException("document is marked non-null but is null");
            }
            this.document = document;
            return this.self();
        }

        public B destinations(Destination.DestinationStore destinations) {
            this.destinations = destinations;
            return this.self();
        }

        public B annotations(AnnotationStore annotations) {
            this.annotations = annotations;
            return this.self();
        }

        public B config(ExtentPDFReporterConfig config) {
            this.config = config;
            return this.self();
        }

        public B report(@NonNull Report report) {
            if (report == null) {
                throw new NullPointerException("report is marked non-null but is null");
            }
            this.report = report;
            return this.self();
        }

        public B pageHeader(PageHeader pageHeader) {
            this.pageHeader = pageHeader;
            return this.self();
        }

        public String toString() {
            return "Section.SectionBuilder(document=" + this.document + ", destinations=" + this.destinations + ", annotations=" + this.annotations + ", config=" + (Object)((Object)this.config) + ", report=" + this.report + ", pageHeader=" + this.pageHeader + ")";
        }
    }
}

