/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.structure;

import java.util.function.Supplier;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;

public class PageCreator {
    public static PDPage createPotraitPage() {
        return new PDPage(PDRectangle.A4);
    }

    public static PDPage createLandscapePage() {
        return new PDPage(new PDRectangle(PDRectangle.A4.getHeight(), PDRectangle.A4.getWidth()));
    }

    public static PDPage createPotraitPageAndAddToDocument(PDDocument document) {
        PDPage page = PageCreator.createPotraitPage();
        document.addPage(page);
        return page;
    }

    public static PDPage createLandscapePageAndAddToDocument(PDDocument document) {
        PDPage page = PageCreator.createLandscapePage();
        document.addPage(page);
        return page;
    }

    public static Supplier<PDPage> potraitPageSupplier() {
        return () -> PageCreator.createPotraitPage();
    }

    public static Supplier<PDPage> landscapePageSupplier() {
        return () -> PageCreator.createLandscapePage();
    }

    PageCreator() {
    }

    public static PageCreatorBuilder builder() {
        return new PageCreatorBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageCreator)) {
            return false;
        }
        PageCreator other = (PageCreator)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageCreator;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "PageCreator()";
    }

    public static class PageCreatorBuilder {
        PageCreatorBuilder() {
        }

        public PageCreator build() {
            return new PageCreator();
        }

        public String toString() {
            return "PageCreator.PageCreatorBuilder()";
        }
    }
}

