/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.structure;

import com.aventstack.extentreports.model.Report;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import tech.grasshopper.reporter.config.ExtentPDFReporterConfig;

public abstract class Display {
    public static final float CONTENT_START_Y = 790.0f;
    public static final float CONTENT_END_Y = 40.0f;
    public static final float CONTENT_MARGIN_TOP_Y = 50.0f;
    protected PDPageContentStream content;
    protected ExtentPDFReporterConfig config;
    protected PDDocument document;
    protected PDPage page;
    protected Report report;
    protected float ylocation;
    protected float xlocation;

    public abstract void display();

    private static float $default$xlocation() {
        return 50.0f;
    }

    protected Display(DisplayBuilder<?, ?> b) {
        this.content = ((DisplayBuilder)b).content;
        this.config = ((DisplayBuilder)b).config;
        this.document = ((DisplayBuilder)b).document;
        this.page = ((DisplayBuilder)b).page;
        this.report = ((DisplayBuilder)b).report;
        this.ylocation = ((DisplayBuilder)b).ylocation;
        this.xlocation = ((DisplayBuilder)b).xlocation$set ? ((DisplayBuilder)b).xlocation$value : Display.$default$xlocation();
    }

    public PDPageContentStream getContent() {
        return this.content;
    }

    public ExtentPDFReporterConfig getConfig() {
        return this.config;
    }

    public PDDocument getDocument() {
        return this.document;
    }

    public PDPage getPage() {
        return this.page;
    }

    public Report getReport() {
        return this.report;
    }

    public float getYlocation() {
        return this.ylocation;
    }

    public float getXlocation() {
        return this.xlocation;
    }

    public void setContent(PDPageContentStream content) {
        this.content = content;
    }

    public void setConfig(ExtentPDFReporterConfig config) {
        this.config = config;
    }

    public void setDocument(PDDocument document) {
        this.document = document;
    }

    public void setPage(PDPage page) {
        this.page = page;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public void setYlocation(float ylocation) {
        this.ylocation = ylocation;
    }

    public void setXlocation(float xlocation) {
        this.xlocation = xlocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Display)) {
            return false;
        }
        Display other = (Display)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getYlocation(), other.getYlocation()) != 0) {
            return false;
        }
        if (Float.compare(this.getXlocation(), other.getXlocation()) != 0) {
            return false;
        }
        PDPageContentStream this$content = this.getContent();
        PDPageContentStream other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        ExtentPDFReporterConfig this$config = this.getConfig();
        ExtentPDFReporterConfig other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)((Object)this$config)).equals((Object)other$config)) {
            return false;
        }
        PDDocument this$document = this.getDocument();
        PDDocument other$document = other.getDocument();
        if (this$document == null ? other$document != null : !this$document.equals(other$document)) {
            return false;
        }
        PDPage this$page = this.getPage();
        PDPage other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        Report this$report = this.getReport();
        Report other$report = other.getReport();
        return !(this$report == null ? other$report != null : !this$report.equals(other$report));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Display;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getYlocation());
        result = result * 59 + Float.floatToIntBits(this.getXlocation());
        PDPageContentStream $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        ExtentPDFReporterConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)((Object)$config)).hashCode());
        PDDocument $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : $document.hashCode());
        PDPage $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        Report $report = this.getReport();
        result = result * 59 + ($report == null ? 43 : $report.hashCode());
        return result;
    }

    public String toString() {
        return "Display(content=" + this.getContent() + ", config=" + (Object)((Object)this.getConfig()) + ", document=" + this.getDocument() + ", page=" + this.getPage() + ", report=" + this.getReport() + ", ylocation=" + this.getYlocation() + ", xlocation=" + this.getXlocation() + ")";
    }

    public static abstract class DisplayBuilder<C extends Display, B extends DisplayBuilder<C, B>> {
        private PDPageContentStream content;
        private ExtentPDFReporterConfig config;
        private PDDocument document;
        private PDPage page;
        private Report report;
        private float ylocation;
        private boolean xlocation$set;
        private float xlocation$value;

        protected abstract B self();

        public abstract C build();

        public B content(PDPageContentStream content) {
            this.content = content;
            return this.self();
        }

        public B config(ExtentPDFReporterConfig config) {
            this.config = config;
            return this.self();
        }

        public B document(PDDocument document) {
            this.document = document;
            return this.self();
        }

        public B page(PDPage page) {
            this.page = page;
            return this.self();
        }

        public B report(Report report) {
            this.report = report;
            return this.self();
        }

        public B ylocation(float ylocation) {
            this.ylocation = ylocation;
            return this.self();
        }

        public B xlocation(float xlocation) {
            this.xlocation$value = xlocation;
            this.xlocation$set = true;
            return this.self();
        }

        public String toString() {
            return "Display.DisplayBuilder(content=" + this.content + ", config=" + (Object)((Object)this.config) + ", document=" + this.document + ", page=" + this.page + ", report=" + this.report + ", ylocation=" + this.ylocation + ", xlocation$value=" + this.xlocation$value + ")";
        }
    }
}

