/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.expanded;

import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.Media;
import com.aventstack.extentreports.model.Test;
import java.awt.Color;
import java.util.ArrayList;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import tech.grasshopper.pdf.annotation.Annotation;
import tech.grasshopper.pdf.structure.cell.TextLinkCell;
import tech.grasshopper.reporter.annotation.AnnotationStore;
import tech.grasshopper.reporter.destination.Destination;
import tech.grasshopper.reporter.destination.DestinationAware;
import tech.grasshopper.reporter.expanded.ExpandedMedia;
import tech.grasshopper.reporter.font.ReportFont;
import tech.grasshopper.reporter.optimizer.TextSanitizer;
import tech.grasshopper.reporter.structure.Display;
import tech.grasshopper.reporter.structure.TableCreator;

public class ExpandedMediaDisplay
extends Display
implements DestinationAware {
    private static final PDFont CONTENT_FONT = ReportFont.BOLD_ITALIC_FONT;
    private static final int NAME_FONT_SIZE = 15;
    private static final float PADDING = 5.0f;
    private static final float WIDTH = 500.0f;
    private static final float NAME_HEIGHT = 25.0f;
    private static final float GAP_HEIGHT = 10.0f;
    private static final float BORDER_WIDTH = 0.0f;
    private static final float MULTI_LINE_SPACING = 1.0f;
    private int destinationY;
    protected Test test;
    private Table.TableBuilder tableBuilder;
    protected final TextSanitizer textSanitizer = TextSanitizer.builder().font(CONTENT_FONT).build();
    private AnnotationStore annotations;

    @Override
    public Destination createDestination() {
        return Destination.builder().id(this.test.getId()).name(this.textSanitizer.sanitizeText(this.test.getName())).yCoord(this.destinationY).page(this.page).build();
    }

    @Override
    public void display() {
        this.tableBuilder = Table.builder().addColumnsOfWidth(new float[]{500.0f}).padding(5.0f).borderWidth(0.0f).font(ReportFont.BOLD_ITALIC_FONT).horizontalAlignment(HorizontalAlignment.LEFT).verticalAlignment(VerticalAlignment.MIDDLE);
        Annotation annotation = Annotation.builder().id(this.test.getId()).build();
        this.annotations.addTestNameMediaAnnotation(annotation);
        this.tableBuilder.addRow(Row.builder().add((AbstractCell)((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)TextLinkCell.builder().annotation(annotation).showLine(false).minHeight(25.0f)).fontSize(Integer.valueOf(15))).text(this.textSanitizer.sanitizeText(this.test.getName()))).lineSpacing(1.0f)).textColor(this.config.getTestNameColor())).build()).build());
        ArrayList<Media> medias = new ArrayList<Media>();
        if (!this.test.getMedia().isEmpty()) {
            medias.addAll(this.test.getMedia());
        }
        for (Log log : this.test.getLogs()) {
            if (!log.hasMedia()) continue;
            medias.add(log.getMedia());
        }
        for (Media media : medias) {
            this.tableBuilder.addRow(Row.builder().add((AbstractCell)ExpandedMedia.builder().media(media).document(this.document).padding(5.0f).build().createImageCell()).borderWidth(1.0f).borderColor(Color.LIGHT_GRAY).build());
        }
        PDPage initialPage = this.document.getPage(this.document.getNumberOfPages() - 1);
        this.destinationY = (int)this.ylocation;
        TableCreator table = TableCreator.builder().tableBuilder(this.tableBuilder).document(this.document).repeatRows(0).startX(this.xlocation).startY(this.ylocation).build();
        table.displayTable();
        this.ylocation = table.getFinalY() - 10.0f;
        this.page = table.getTableStartPage();
        if (!initialPage.equals((Object)this.page)) {
            this.destinationY = 790;
        }
    }

    protected ExpandedMediaDisplay(ExpandedMediaDisplayBuilder<?, ?> b) {
        super(b);
        this.destinationY = ((ExpandedMediaDisplayBuilder)b).destinationY;
        this.test = ((ExpandedMediaDisplayBuilder)b).test;
        this.tableBuilder = ((ExpandedMediaDisplayBuilder)b).tableBuilder;
        this.annotations = ((ExpandedMediaDisplayBuilder)b).annotations;
    }

    public static ExpandedMediaDisplayBuilder<?, ?> builder() {
        return new ExpandedMediaDisplayBuilderImpl();
    }

    public int getDestinationY() {
        return this.destinationY;
    }

    public Test getTest() {
        return this.test;
    }

    public Table.TableBuilder getTableBuilder() {
        return this.tableBuilder;
    }

    public TextSanitizer getTextSanitizer() {
        return this.textSanitizer;
    }

    public AnnotationStore getAnnotations() {
        return this.annotations;
    }

    public void setDestinationY(int destinationY) {
        this.destinationY = destinationY;
    }

    public void setTest(Test test) {
        this.test = test;
    }

    public void setTableBuilder(Table.TableBuilder tableBuilder) {
        this.tableBuilder = tableBuilder;
    }

    public void setAnnotations(AnnotationStore annotations) {
        this.annotations = annotations;
    }

    @Override
    public String toString() {
        return "ExpandedMediaDisplay(destinationY=" + this.getDestinationY() + ", test=" + this.getTest() + ", tableBuilder=" + this.getTableBuilder() + ", textSanitizer=" + this.getTextSanitizer() + ", annotations=" + this.getAnnotations() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExpandedMediaDisplay)) {
            return false;
        }
        ExpandedMediaDisplay other = (ExpandedMediaDisplay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDestinationY() != other.getDestinationY()) {
            return false;
        }
        Test this$test = this.getTest();
        Test other$test = other.getTest();
        if (this$test == null ? other$test != null : !this$test.equals(other$test)) {
            return false;
        }
        Table.TableBuilder this$tableBuilder = this.getTableBuilder();
        Table.TableBuilder other$tableBuilder = other.getTableBuilder();
        if (this$tableBuilder == null ? other$tableBuilder != null : !this$tableBuilder.equals(other$tableBuilder)) {
            return false;
        }
        TextSanitizer this$textSanitizer = this.getTextSanitizer();
        TextSanitizer other$textSanitizer = other.getTextSanitizer();
        if (this$textSanitizer == null ? other$textSanitizer != null : !((Object)this$textSanitizer).equals(other$textSanitizer)) {
            return false;
        }
        AnnotationStore this$annotations = this.getAnnotations();
        AnnotationStore other$annotations = other.getAnnotations();
        return !(this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExpandedMediaDisplay;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDestinationY();
        Test $test = this.getTest();
        result = result * 59 + ($test == null ? 43 : $test.hashCode());
        Table.TableBuilder $tableBuilder = this.getTableBuilder();
        result = result * 59 + ($tableBuilder == null ? 43 : $tableBuilder.hashCode());
        TextSanitizer $textSanitizer = this.getTextSanitizer();
        result = result * 59 + ($textSanitizer == null ? 43 : ((Object)$textSanitizer).hashCode());
        AnnotationStore $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        return result;
    }

    private static final class ExpandedMediaDisplayBuilderImpl
    extends ExpandedMediaDisplayBuilder<ExpandedMediaDisplay, ExpandedMediaDisplayBuilderImpl> {
        private ExpandedMediaDisplayBuilderImpl() {
        }

        @Override
        protected ExpandedMediaDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public ExpandedMediaDisplay build() {
            return new ExpandedMediaDisplay(this);
        }
    }

    public static abstract class ExpandedMediaDisplayBuilder<C extends ExpandedMediaDisplay, B extends ExpandedMediaDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private int destinationY;
        private Test test;
        private Table.TableBuilder tableBuilder;
        private AnnotationStore annotations;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B destinationY(int destinationY) {
            this.destinationY = destinationY;
            return (B)this.self();
        }

        public B test(Test test) {
            this.test = test;
            return (B)this.self();
        }

        public B tableBuilder(Table.TableBuilder tableBuilder) {
            this.tableBuilder = tableBuilder;
            return (B)this.self();
        }

        public B annotations(AnnotationStore annotations) {
            this.annotations = annotations;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ExpandedMediaDisplay.ExpandedMediaDisplayBuilder(super=" + super.toString() + ", destinationY=" + this.destinationY + ", test=" + this.test + ", tableBuilder=" + this.tableBuilder + ", annotations=" + this.annotations + ")";
        }
    }
}

