/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.expanded;

import com.aventstack.extentreports.model.Media;
import com.aventstack.extentreports.model.service.MediaService;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.vandeseer.easytable.structure.cell.ImageCell;

public class ExpandedMedia {
    private Media media;
    private PDDocument document;
    private float padding;
    private static PDImageXObject imageNotFound = null;

    public ImageCell createImageCell() {
        PDImageXObject image = null;
        try {
            if (imageNotFound == null) {
                imageNotFound = PDImageXObject.createFromFile((String)"src/main/resources/not-found-image.png", (PDDocument)this.document);
            }
            image = MediaService.isBase64((Media)this.media) ? imageNotFound : PDImageXObject.createFromFile((String)this.media.getPath(), (PDDocument)this.document);
        }
        catch (IOException e) {
            image = imageNotFound;
        }
        return ((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)ImageCell.builder().image(image).width((float)image.getWidth())).padding(this.padding)).maxHeight((float)image.getHeight()).build();
    }

    ExpandedMedia(Media media, PDDocument document, float padding) {
        this.media = media;
        this.document = document;
        this.padding = padding;
    }

    public static ExpandedMediaBuilder builder() {
        return new ExpandedMediaBuilder();
    }

    public Media getMedia() {
        return this.media;
    }

    public PDDocument getDocument() {
        return this.document;
    }

    public float getPadding() {
        return this.padding;
    }

    public void setMedia(Media media) {
        this.media = media;
    }

    public void setDocument(PDDocument document) {
        this.document = document;
    }

    public void setPadding(float padding) {
        this.padding = padding;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExpandedMedia)) {
            return false;
        }
        ExpandedMedia other = (ExpandedMedia)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getPadding(), other.getPadding()) != 0) {
            return false;
        }
        Media this$media = this.getMedia();
        Media other$media = other.getMedia();
        if (this$media == null ? other$media != null : !this$media.equals(other$media)) {
            return false;
        }
        PDDocument this$document = this.getDocument();
        PDDocument other$document = other.getDocument();
        return !(this$document == null ? other$document != null : !this$document.equals(other$document));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExpandedMedia;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getPadding());
        Media $media = this.getMedia();
        result = result * 59 + ($media == null ? 43 : $media.hashCode());
        PDDocument $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : $document.hashCode());
        return result;
    }

    public String toString() {
        return "ExpandedMedia(media=" + this.getMedia() + ", document=" + this.getDocument() + ", padding=" + this.getPadding() + ")";
    }

    public static class ExpandedMediaBuilder {
        private Media media;
        private PDDocument document;
        private float padding;

        ExpandedMediaBuilder() {
        }

        public ExpandedMediaBuilder media(Media media) {
            this.media = media;
            return this;
        }

        public ExpandedMediaBuilder document(PDDocument document) {
            this.document = document;
            return this;
        }

        public ExpandedMediaBuilder padding(float padding) {
            this.padding = padding;
            return this;
        }

        public ExpandedMedia build() {
            return new ExpandedMedia(this.media, this.document, this.padding);
        }

        public String toString() {
            return "ExpandedMedia.ExpandedMediaBuilder(media=" + this.media + ", document=" + this.document + ", padding=" + this.padding + ")";
        }
    }
}

