/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.dashboard;

import java.time.LocalDateTime;
import org.apache.pdfbox.pdmodel.font.PDFont;
import tech.grasshopper.reporter.component.text.Text;
import tech.grasshopper.reporter.component.text.TextComponent;
import tech.grasshopper.reporter.font.ReportFont;
import tech.grasshopper.reporter.optimizer.TextLengthOptimizer;
import tech.grasshopper.reporter.optimizer.TextSanitizer;
import tech.grasshopper.reporter.structure.Display;

public class DashboardHeaderDisplay
extends Display {
    private static final int TITLE_FONT_SIZE = 22;
    private static final PDFont TITLE_FONT = ReportFont.BOLD_FONT;
    private static final int TITLE_X_LOCATION = 50;
    private static final int DATE_FONT_SIZE = 16;
    private static final int DATE_X_LOCATION = 600;
    private static final int Y_LOCATION = 520;
    private final TextLengthOptimizer titleLengthOptimizer = TextLengthOptimizer.builder().font(TITLE_FONT).fontsize(22).spaceWidth(530).build();
    private final TextSanitizer textSanitizer = TextSanitizer.builder().font(TITLE_FONT).build();

    @Override
    public void display() {
        this.createReportTitleText();
        this.createReportDateText();
    }

    private void createReportTitleText() {
        Text text = Text.builder().textColor(this.config.getReportNameColor()).font(TITLE_FONT).fontSize(22.0f).text(this.titleLengthOptimizer.optimizeText(this.textSanitizer.sanitizeText(this.config.getReportName()))).xlocation(50.0f).ylocation(520.0f).build();
        ((TextComponent)((TextComponent.TextComponentBuilder)((TextComponent.TextComponentBuilder)TextComponent.builder().content(this.content)).text(text)).build()).display();
    }

    private void createReportDateText() {
        Text text = Text.builder().textColor(this.config.getReportDateColor()).font(ReportFont.REGULAR_FONT).fontSize(16.0f).xlocation(600.0f).ylocation(520.0f).text(LocalDateTime.now().format(this.config.getReportDateFormat())).build();
        ((TextComponent)((TextComponent.TextComponentBuilder)((TextComponent.TextComponentBuilder)TextComponent.builder().content(this.content)).text(text)).build()).display();
    }

    protected DashboardHeaderDisplay(DashboardHeaderDisplayBuilder<?, ?> b) {
        super(b);
    }

    public static DashboardHeaderDisplayBuilder<?, ?> builder() {
        return new DashboardHeaderDisplayBuilderImpl();
    }

    public TextLengthOptimizer getTitleLengthOptimizer() {
        return this.titleLengthOptimizer;
    }

    public TextSanitizer getTextSanitizer() {
        return this.textSanitizer;
    }

    @Override
    public String toString() {
        return "DashboardHeaderDisplay(titleLengthOptimizer=" + this.getTitleLengthOptimizer() + ", textSanitizer=" + this.getTextSanitizer() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DashboardHeaderDisplay)) {
            return false;
        }
        DashboardHeaderDisplay other = (DashboardHeaderDisplay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TextLengthOptimizer this$titleLengthOptimizer = this.getTitleLengthOptimizer();
        TextLengthOptimizer other$titleLengthOptimizer = other.getTitleLengthOptimizer();
        if (this$titleLengthOptimizer == null ? other$titleLengthOptimizer != null : !((Object)this$titleLengthOptimizer).equals(other$titleLengthOptimizer)) {
            return false;
        }
        TextSanitizer this$textSanitizer = this.getTextSanitizer();
        TextSanitizer other$textSanitizer = other.getTextSanitizer();
        return !(this$textSanitizer == null ? other$textSanitizer != null : !((Object)this$textSanitizer).equals(other$textSanitizer));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DashboardHeaderDisplay;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TextLengthOptimizer $titleLengthOptimizer = this.getTitleLengthOptimizer();
        result = result * 59 + ($titleLengthOptimizer == null ? 43 : ((Object)$titleLengthOptimizer).hashCode());
        TextSanitizer $textSanitizer = this.getTextSanitizer();
        result = result * 59 + ($textSanitizer == null ? 43 : ((Object)$textSanitizer).hashCode());
        return result;
    }

    private static final class DashboardHeaderDisplayBuilderImpl
    extends DashboardHeaderDisplayBuilder<DashboardHeaderDisplay, DashboardHeaderDisplayBuilderImpl> {
        private DashboardHeaderDisplayBuilderImpl() {
        }

        @Override
        protected DashboardHeaderDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public DashboardHeaderDisplay build() {
            return new DashboardHeaderDisplay(this);
        }
    }

    public static abstract class DashboardHeaderDisplayBuilder<C extends DashboardHeaderDisplay, B extends DashboardHeaderDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "DashboardHeaderDisplay.DashboardHeaderDisplayBuilder(super=" + super.toString() + ")";
        }
    }
}

