/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.dashboard;

import com.aventstack.extentreports.Status;
import java.awt.Color;
import java.util.Map;
import org.knowm.xchart.PieChart;
import org.knowm.xchart.PieSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.PieStyler;
import org.knowm.xchart.style.Styler;
import tech.grasshopper.reporter.component.chart.ChartDisplayer;
import tech.grasshopper.reporter.component.text.Text;
import tech.grasshopper.reporter.component.text.TextComponent;
import tech.grasshopper.reporter.dashboard.AnalysisStrategyDisplay;
import tech.grasshopper.reporter.font.ReportFont;
import tech.grasshopper.reporter.structure.Display;

public class DashboardDonutChartDisplay
extends Display {
    private PieChart chart;
    private static final int CHART_TITLE_X_PADDING = 10;
    private static final int CHART_TITLE_Y_LOCATION = 390;
    private static final int CHART_TITLE_FONT_SIZE = 16;
    private static final int CHART_HEIGHT = 170;
    private static final int CHART_Y_LOCATION = 210;
    private AnalysisStrategyDisplay strategyDisplay;

    @Override
    public void display() {
        this.strategyDisplay = AnalysisStrategyDisplay.displaySettings(this.report.getStats().getAnalysisStrategy());
        this.createFirstChartTitle();
        this.createSecondChartTitle();
        this.createThirdChartTitle();
        this.createLogsChartTitle();
        this.createFirstDonutChart();
        this.createSecondDonutChart();
        this.createThirdDonutChart();
        this.createLogsDonutChart();
    }

    private void createFirstChartTitle() {
        Text text = Text.builder().fontSize(16.0f).xlocation(this.strategyDisplay.firstLevelChartXLocation() + 10).ylocation(390.0f).text(this.strategyDisplay.firstLevelText()).font(ReportFont.ITALIC_FONT).build();
        ((TextComponent)((TextComponent.TextComponentBuilder)((TextComponent.TextComponentBuilder)TextComponent.builder().content(this.content)).text(text)).build()).display();
    }

    private void createSecondChartTitle() {
        Text text = Text.builder().fontSize(16.0f).xlocation(this.strategyDisplay.secondLevelChartXLocation() + 10).ylocation(390.0f).text(this.strategyDisplay.secondLevelText()).font(ReportFont.ITALIC_FONT).build();
        ((TextComponent)((TextComponent.TextComponentBuilder)((TextComponent.TextComponentBuilder)TextComponent.builder().content(this.content)).text(text)).build()).display();
    }

    private void createThirdChartTitle() {
        Text text = Text.builder().fontSize(16.0f).xlocation(this.strategyDisplay.thirdLevelChartXLocation() + 10).ylocation(390.0f).text(this.strategyDisplay.thirdLevelText()).font(ReportFont.ITALIC_FONT).build();
        ((TextComponent)((TextComponent.TextComponentBuilder)((TextComponent.TextComponentBuilder)TextComponent.builder().content(this.content)).text(text)).build()).display();
    }

    private void createLogsChartTitle() {
        if (this.strategyDisplay.displayLogsChart()) {
            Text text = Text.builder().fontSize(16.0f).xlocation(this.strategyDisplay.logsChartXLocation() + 10).ylocation(390.0f).text(this.strategyDisplay.logsText()).font(ReportFont.ITALIC_FONT).build();
            ((TextComponent)((TextComponent.TextComponentBuilder)((TextComponent.TextComponentBuilder)TextComponent.builder().content(this.content)).text(text)).build()).display();
        }
    }

    private void createFirstDonutChart() {
        this.createDonutChart(this.report.getStats().getParent(), this.strategyDisplay.firstLevelChartXLocation());
    }

    private void createSecondDonutChart() {
        this.createDonutChart(this.report.getStats().getChild(), this.strategyDisplay.secondLevelChartXLocation());
    }

    private void createThirdDonutChart() {
        this.createDonutChart(this.report.getStats().getGrandchild(), this.strategyDisplay.thirdLevelChartXLocation());
    }

    private void createLogsDonutChart() {
        if (this.strategyDisplay.displayLogsChart()) {
            this.createDonutChart(this.report.getStats().getLog(), this.strategyDisplay.logsChartXLocation());
        }
    }

    private void createDonutChart(Map<Status, Long> data, float xLocation) {
        this.chart = new PieChart(this.strategyDisplay.chartWidth(), 170, Styler.ChartTheme.XChart);
        this.updateChartStyler((PieStyler)this.chart.getStyler());
        this.updateChartData(data);
        ((ChartDisplayer)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)ChartDisplayer.builder().document(this.document)).content(this.content)).chart((Chart<?, ?>)this.chart)).xBottomLeft(xLocation)).yBottomLeft(210.0f)).build()).display();
    }

    private void updateChartStyler(PieStyler styler) {
        styler.setSeriesColors(new Color[]{this.config.getPassColor(), this.config.getFailColor(), this.config.getSkipColor(), this.config.getWarnColor(), this.config.getInfoColor()});
        styler.setLegendVisible(false);
        styler.setPlotContentSize(0.85);
        styler.setPlotBorderVisible(true);
        styler.setPlotBorderColor(Color.BLACK);
        styler.setChartPadding(1);
        styler.setClockwiseDirectionType(PieStyler.ClockwiseDirectionType.CLOCKWISE);
        styler.setHasAnnotations(false);
        styler.setDefaultSeriesRenderStyle(PieSeries.PieSeriesRenderStyle.Donut);
        styler.setDonutThickness(0.4);
        styler.setSumVisible(true);
        styler.setSumFontSize(20.0f);
        styler.setDecimalPattern("#");
        styler.setChartBackgroundColor(Color.WHITE);
    }

    private void updateChartData(Map<Status, Long> statusData) {
        this.chart.addSeries(Status.PASS.toString(), (Number)statusData.getOrDefault(Status.PASS, 0L));
        this.chart.addSeries(Status.FAIL.toString(), (Number)statusData.getOrDefault(Status.FAIL, 0L));
        this.chart.addSeries(Status.SKIP.toString(), (Number)statusData.getOrDefault(Status.SKIP, 0L));
        this.chart.addSeries(Status.WARNING.toString(), (Number)statusData.getOrDefault(Status.WARNING, 0L));
        this.chart.addSeries(Status.INFO.toString(), (Number)statusData.getOrDefault(Status.INFO, 0L));
    }

    protected DashboardDonutChartDisplay(DashboardDonutChartDisplayBuilder<?, ?> b) {
        super(b);
        this.chart = ((DashboardDonutChartDisplayBuilder)b).chart;
        this.strategyDisplay = ((DashboardDonutChartDisplayBuilder)b).strategyDisplay;
    }

    public static DashboardDonutChartDisplayBuilder<?, ?> builder() {
        return new DashboardDonutChartDisplayBuilderImpl();
    }

    public PieChart getChart() {
        return this.chart;
    }

    public AnalysisStrategyDisplay getStrategyDisplay() {
        return this.strategyDisplay;
    }

    public void setChart(PieChart chart) {
        this.chart = chart;
    }

    public void setStrategyDisplay(AnalysisStrategyDisplay strategyDisplay) {
        this.strategyDisplay = strategyDisplay;
    }

    @Override
    public String toString() {
        return "DashboardDonutChartDisplay(chart=" + this.getChart() + ", strategyDisplay=" + (Object)((Object)this.getStrategyDisplay()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DashboardDonutChartDisplay)) {
            return false;
        }
        DashboardDonutChartDisplay other = (DashboardDonutChartDisplay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PieChart this$chart = this.getChart();
        PieChart other$chart = other.getChart();
        if (this$chart == null ? other$chart != null : !this$chart.equals(other$chart)) {
            return false;
        }
        AnalysisStrategyDisplay this$strategyDisplay = this.getStrategyDisplay();
        AnalysisStrategyDisplay other$strategyDisplay = other.getStrategyDisplay();
        return !(this$strategyDisplay == null ? other$strategyDisplay != null : !((Object)((Object)this$strategyDisplay)).equals((Object)other$strategyDisplay));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DashboardDonutChartDisplay;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PieChart $chart = this.getChart();
        result = result * 59 + ($chart == null ? 43 : $chart.hashCode());
        AnalysisStrategyDisplay $strategyDisplay = this.getStrategyDisplay();
        result = result * 59 + ($strategyDisplay == null ? 43 : ((Object)((Object)$strategyDisplay)).hashCode());
        return result;
    }

    private static final class DashboardDonutChartDisplayBuilderImpl
    extends DashboardDonutChartDisplayBuilder<DashboardDonutChartDisplay, DashboardDonutChartDisplayBuilderImpl> {
        private DashboardDonutChartDisplayBuilderImpl() {
        }

        @Override
        protected DashboardDonutChartDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public DashboardDonutChartDisplay build() {
            return new DashboardDonutChartDisplay(this);
        }
    }

    public static abstract class DashboardDonutChartDisplayBuilder<C extends DashboardDonutChartDisplay, B extends DashboardDonutChartDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private PieChart chart;
        private AnalysisStrategyDisplay strategyDisplay;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B chart(PieChart chart) {
            this.chart = chart;
            return (B)this.self();
        }

        public B strategyDisplay(AnalysisStrategyDisplay strategyDisplay) {
            this.strategyDisplay = strategyDisplay;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DashboardDonutChartDisplay.DashboardDonutChartDisplayBuilder(super=" + super.toString() + ", chart=" + this.chart + ", strategyDisplay=" + (Object)((Object)this.strategyDisplay) + ")";
        }
    }
}

