/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.dashboard;

import com.aventstack.extentreports.Status;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;
import tech.grasshopper.reporter.component.Component;
import tech.grasshopper.reporter.component.decorator.BackgroundDecorator;
import tech.grasshopper.reporter.component.text.Text;
import tech.grasshopper.reporter.component.text.TextComponent;
import tech.grasshopper.reporter.dashboard.AnalysisStrategyDisplay;
import tech.grasshopper.reporter.font.ReportFont;
import tech.grasshopper.reporter.structure.Display;

public class DashboardChartLegendDisplay
extends Display {
    private static final int TOP_LEGEND_Y_LOCATION = 180;
    private static final int LEGEND_Y_GAP = 25;
    private static final int CHART_TITLE_X_PADDING = 25;
    private static final int LEGEND_KEY_WIDTH = 50;
    private static final int LEGEND_KEY_HEIGHT = 20;
    private static final int LEGEND_KEY_FONT_SIZE = 11;
    private static final int LEGEND_VALUE_FONT_SIZE = 14;
    private static final Map<Status, Color> statusColor = new LinkedHashMap<Status, Color>();
    private AnalysisStrategyDisplay strategyDisplay;

    @Override
    public void display() {
        statusColor.put(Status.PASS, this.config.getPassColor());
        statusColor.put(Status.FAIL, this.config.getFailColor());
        statusColor.put(Status.SKIP, this.config.getSkipColor());
        statusColor.put(Status.WARNING, this.config.getWarnColor());
        statusColor.put(Status.INFO, this.config.getInfoColor());
        this.strategyDisplay = AnalysisStrategyDisplay.displaySettings(this.report.getStats().getAnalysisStrategy());
        this.createFirstChartDataBox();
        this.createSecondChartDataBox();
        this.createThirdChartDataBox();
        this.createLogsChartDataBox();
    }

    private void createFirstChartDataBox() {
        this.createLegendData(this.report.getStats().getParent(), this.strategyDisplay.firstLevelChartXLocation() + 25);
    }

    private void createSecondChartDataBox() {
        this.createLegendData(this.report.getStats().getChild(), this.strategyDisplay.secondLevelChartXLocation() + 25);
    }

    private void createThirdChartDataBox() {
        this.createLegendData(this.report.getStats().getGrandchild(), this.strategyDisplay.thirdLevelChartXLocation() + 25);
    }

    private void createLogsChartDataBox() {
        if (this.strategyDisplay.displayLogsChart()) {
            this.createLegendData(this.report.getStats().getLog(), this.strategyDisplay.logsChartXLocation() + 25);
        }
    }

    private void createLegendData(Map<Status, Long> statusData, float xlocation) {
        float yTopLocation = 180.0f;
        for (Map.Entry<Status, Color> entry : statusColor.entrySet()) {
            long value = statusData.getOrDefault(entry.getKey(), 0L);
            if (value <= 0L) continue;
            this.createLegendKey(entry.getKey().toString(), xlocation, yTopLocation, entry.getValue());
            this.createLegendValue(xlocation, yTopLocation, value);
            yTopLocation -= 25.0f;
        }
    }

    private void createLegendKey(String legendText, float xlocation, float ylocation, Color legendColor) {
        Text text = Text.builder().fontSize(11.0f).xlocation(xlocation).ylocation(ylocation).text(legendText).font(ReportFont.ITALIC_FONT).build();
        Component component = ((TextComponent.TextComponentBuilder)((TextComponent.TextComponentBuilder)TextComponent.builder().content(this.content)).text(text)).build();
        component = ((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)BackgroundDecorator.builder().component(component)).content(this.content)).containerColor(legendColor)).xContainerBottomLeft(xlocation - 5.0f)).yContainerBottomLeft(ylocation - 6.0f)).containerWidth(50.0f)).containerHeight(20.0f)).build();
        component.display();
    }

    private void createLegendValue(float xlocation, float ylocation, Long legendValue) {
        Text text = Text.builder().fontSize(14.0f).xlocation(xlocation + 65.0f).ylocation(ylocation).text(String.valueOf(legendValue)).font(ReportFont.BOLD_FONT).build();
        Component component = ((TextComponent.TextComponentBuilder)((TextComponent.TextComponentBuilder)TextComponent.builder().content(this.content)).text(text)).build();
        component.display();
    }

    protected DashboardChartLegendDisplay(DashboardChartLegendDisplayBuilder<?, ?> b) {
        super(b);
        this.strategyDisplay = ((DashboardChartLegendDisplayBuilder)b).strategyDisplay;
    }

    public static DashboardChartLegendDisplayBuilder<?, ?> builder() {
        return new DashboardChartLegendDisplayBuilderImpl();
    }

    public AnalysisStrategyDisplay getStrategyDisplay() {
        return this.strategyDisplay;
    }

    public void setStrategyDisplay(AnalysisStrategyDisplay strategyDisplay) {
        this.strategyDisplay = strategyDisplay;
    }

    @Override
    public String toString() {
        return "DashboardChartLegendDisplay(strategyDisplay=" + (Object)((Object)this.getStrategyDisplay()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DashboardChartLegendDisplay)) {
            return false;
        }
        DashboardChartLegendDisplay other = (DashboardChartLegendDisplay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AnalysisStrategyDisplay this$strategyDisplay = this.getStrategyDisplay();
        AnalysisStrategyDisplay other$strategyDisplay = other.getStrategyDisplay();
        return !(this$strategyDisplay == null ? other$strategyDisplay != null : !((Object)((Object)this$strategyDisplay)).equals((Object)other$strategyDisplay));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DashboardChartLegendDisplay;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AnalysisStrategyDisplay $strategyDisplay = this.getStrategyDisplay();
        result = result * 59 + ($strategyDisplay == null ? 43 : ((Object)((Object)$strategyDisplay)).hashCode());
        return result;
    }

    private static final class DashboardChartLegendDisplayBuilderImpl
    extends DashboardChartLegendDisplayBuilder<DashboardChartLegendDisplay, DashboardChartLegendDisplayBuilderImpl> {
        private DashboardChartLegendDisplayBuilderImpl() {
        }

        @Override
        protected DashboardChartLegendDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public DashboardChartLegendDisplay build() {
            return new DashboardChartLegendDisplay(this);
        }
    }

    public static abstract class DashboardChartLegendDisplayBuilder<C extends DashboardChartLegendDisplay, B extends DashboardChartLegendDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private AnalysisStrategyDisplay strategyDisplay;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B strategyDisplay(AnalysisStrategyDisplay strategyDisplay) {
            this.strategyDisplay = strategyDisplay;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DashboardChartLegendDisplay.DashboardChartLegendDisplayBuilder(super=" + super.toString() + ", strategyDisplay=" + (Object)((Object)this.strategyDisplay) + ")";
        }
    }
}

