/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.context.detail;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.model.NamedAttribute;
import com.aventstack.extentreports.model.context.NamedAttributeContext;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import org.vandeseer.easytable.structure.cell.paragraph.ParagraphCell;
import org.vandeseer.easytable.structure.cell.paragraph.StyledText;
import tech.grasshopper.reporter.context.AttributeType;
import tech.grasshopper.reporter.destination.Destination;
import tech.grasshopper.reporter.destination.DestinationAware;
import tech.grasshopper.reporter.font.ReportFont;
import tech.grasshopper.reporter.optimizer.TextSanitizer;
import tech.grasshopper.reporter.structure.Display;
import tech.grasshopper.reporter.structure.TableCreator;

public class AttributeTestStatusBasicDisplay
extends Display
implements DestinationAware {
    private static final PDFont NAME_FONT = ReportFont.BOLD_ITALIC_FONT;
    private static final int NAME_FONT_SIZE = 15;
    private static final int STATUS_FONT_SIZE = 12;
    private static final float NAME_STATUS_WIDTH = 500.0f;
    private static final float NAME_HEIGHT = 25.0f;
    private static final float STATUS_HEIGHT = 20.0f;
    private static final float GAP_HEIGHT = 5.0f;
    private static final float PADDING = 5.0f;
    protected static final float MULTILINE_SPACING = 1.0f;
    protected NamedAttributeContext<? extends NamedAttribute> attribute;
    protected AttributeType type;
    protected Table.TableBuilder tableBuilder;
    private int destinationY;
    protected final TextSanitizer textSanitizer = TextSanitizer.builder().font(NAME_FONT).build();

    @Override
    public void display() {
        this.createDetailsTableBuilder();
        this.createNameRow();
        this.createStatusRow();
        this.drawDetailsTable();
    }

    private void createDetailsTableBuilder() {
        this.tableBuilder = Table.builder().addColumnsOfWidth(new float[]{500.0f}).padding(5.0f).borderWidth(0.0f).horizontalAlignment(HorizontalAlignment.LEFT).verticalAlignment(VerticalAlignment.MIDDLE);
    }

    private void createNameRow() {
        this.tableBuilder.addRow(Row.builder().add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().minHeight(25.0f)).fontSize(Integer.valueOf(15))).font(NAME_FONT)).text(this.type.toString().toLowerCase() + "- " + this.textSanitizer.sanitizeText(this.attribute.getAttr().getName())).wordBreak(Boolean.valueOf(true))).lineSpacing(1.0f)).textColor(this.config.attributeHeaderColor(this.type))).build()).build());
    }

    private void createStatusRow() {
        ParagraphCell.Paragraph.ParagraphBuilder paraBuilder = ParagraphCell.Paragraph.builder();
        for (Status status : Status.values()) {
            if (this.attribute.getStatusDist().getOrDefault(status, 0) <= 0) continue;
            paraBuilder.append(StyledText.builder().text("/ " + this.attribute.getStatusDist().get(status) + " " + status + " /").color(this.config.statusColor(status)).build());
        }
        this.tableBuilder.addRow(Row.builder().height(Float.valueOf(20.0f)).fontSize(Integer.valueOf(12)).font(ReportFont.BOLD_ITALIC_FONT).add((AbstractCell)ParagraphCell.builder().paragraph(paraBuilder.build()).build()).build());
    }

    protected void drawDetailsTable() {
        PDPage initialPage = this.document.getPage(this.document.getNumberOfPages() - 1);
        this.destinationY = (int)this.ylocation;
        TableCreator table = TableCreator.builder().tableBuilder(this.tableBuilder).document(this.document).startX(this.xlocation).startY(this.ylocation).repeatRows(2).build();
        table.displayTable();
        this.ylocation = table.getFinalY() - 5.0f;
        this.page = table.getTableStartPage();
        if (!initialPage.equals((Object)this.page)) {
            this.destinationY = 790;
        }
    }

    @Override
    public Destination createDestination() {
        return Destination.builder().name(this.type.toString().toLowerCase() + "- " + this.attribute.getAttr().getName()).yCoord(this.destinationY).page(this.page).build();
    }

    protected AttributeTestStatusBasicDisplay(AttributeTestStatusBasicDisplayBuilder<?, ?> b) {
        super(b);
        this.attribute = ((AttributeTestStatusBasicDisplayBuilder)b).attribute;
        this.type = ((AttributeTestStatusBasicDisplayBuilder)b).type;
        this.tableBuilder = ((AttributeTestStatusBasicDisplayBuilder)b).tableBuilder;
        this.destinationY = ((AttributeTestStatusBasicDisplayBuilder)b).destinationY;
    }

    public static AttributeTestStatusBasicDisplayBuilder<?, ?> builder() {
        return new AttributeTestStatusBasicDisplayBuilderImpl();
    }

    public NamedAttributeContext<? extends NamedAttribute> getAttribute() {
        return this.attribute;
    }

    public AttributeType getType() {
        return this.type;
    }

    public Table.TableBuilder getTableBuilder() {
        return this.tableBuilder;
    }

    public int getDestinationY() {
        return this.destinationY;
    }

    public TextSanitizer getTextSanitizer() {
        return this.textSanitizer;
    }

    public void setAttribute(NamedAttributeContext<? extends NamedAttribute> attribute) {
        this.attribute = attribute;
    }

    public void setType(AttributeType type) {
        this.type = type;
    }

    public void setTableBuilder(Table.TableBuilder tableBuilder) {
        this.tableBuilder = tableBuilder;
    }

    public void setDestinationY(int destinationY) {
        this.destinationY = destinationY;
    }

    @Override
    public String toString() {
        return "AttributeTestStatusBasicDisplay(attribute=" + this.getAttribute() + ", type=" + (Object)((Object)this.getType()) + ", tableBuilder=" + this.getTableBuilder() + ", destinationY=" + this.getDestinationY() + ", textSanitizer=" + this.getTextSanitizer() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeTestStatusBasicDisplay)) {
            return false;
        }
        AttributeTestStatusBasicDisplay other = (AttributeTestStatusBasicDisplay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDestinationY() != other.getDestinationY()) {
            return false;
        }
        NamedAttributeContext<? extends NamedAttribute> this$attribute = this.getAttribute();
        NamedAttributeContext<? extends NamedAttribute> other$attribute = other.getAttribute();
        if (this$attribute == null ? other$attribute != null : !this$attribute.equals(other$attribute)) {
            return false;
        }
        AttributeType this$type = this.getType();
        AttributeType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Table.TableBuilder this$tableBuilder = this.getTableBuilder();
        Table.TableBuilder other$tableBuilder = other.getTableBuilder();
        if (this$tableBuilder == null ? other$tableBuilder != null : !this$tableBuilder.equals(other$tableBuilder)) {
            return false;
        }
        TextSanitizer this$textSanitizer = this.getTextSanitizer();
        TextSanitizer other$textSanitizer = other.getTextSanitizer();
        return !(this$textSanitizer == null ? other$textSanitizer != null : !((Object)this$textSanitizer).equals(other$textSanitizer));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AttributeTestStatusBasicDisplay;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDestinationY();
        NamedAttributeContext<? extends NamedAttribute> $attribute = this.getAttribute();
        result = result * 59 + ($attribute == null ? 43 : $attribute.hashCode());
        AttributeType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Table.TableBuilder $tableBuilder = this.getTableBuilder();
        result = result * 59 + ($tableBuilder == null ? 43 : $tableBuilder.hashCode());
        TextSanitizer $textSanitizer = this.getTextSanitizer();
        result = result * 59 + ($textSanitizer == null ? 43 : ((Object)$textSanitizer).hashCode());
        return result;
    }

    private static final class AttributeTestStatusBasicDisplayBuilderImpl
    extends AttributeTestStatusBasicDisplayBuilder<AttributeTestStatusBasicDisplay, AttributeTestStatusBasicDisplayBuilderImpl> {
        private AttributeTestStatusBasicDisplayBuilderImpl() {
        }

        @Override
        protected AttributeTestStatusBasicDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public AttributeTestStatusBasicDisplay build() {
            return new AttributeTestStatusBasicDisplay(this);
        }
    }

    public static abstract class AttributeTestStatusBasicDisplayBuilder<C extends AttributeTestStatusBasicDisplay, B extends AttributeTestStatusBasicDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private NamedAttributeContext<? extends NamedAttribute> attribute;
        private AttributeType type;
        private Table.TableBuilder tableBuilder;
        private int destinationY;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B attribute(NamedAttributeContext<? extends NamedAttribute> attribute) {
            this.attribute = attribute;
            return (B)this.self();
        }

        public B type(AttributeType type) {
            this.type = type;
            return (B)this.self();
        }

        public B tableBuilder(Table.TableBuilder tableBuilder) {
            this.tableBuilder = tableBuilder;
            return (B)this.self();
        }

        public B destinationY(int destinationY) {
            this.destinationY = destinationY;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "AttributeTestStatusBasicDisplay.AttributeTestStatusBasicDisplayBuilder(super=" + super.toString() + ", attribute=" + this.attribute + ", type=" + (Object)((Object)this.type) + ", tableBuilder=" + this.tableBuilder + ", destinationY=" + this.destinationY + ")";
        }
    }
}

