/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.context;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.model.NameValuePair;
import com.aventstack.extentreports.model.NamedAttribute;
import com.aventstack.extentreports.model.context.NamedAttributeContext;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.structure.Table;
import tech.grasshopper.reporter.context.AttributeType;
import tech.grasshopper.reporter.destination.Destination;
import tech.grasshopper.reporter.destination.DestinationAware;
import tech.grasshopper.reporter.exception.PdfReportException;
import tech.grasshopper.reporter.font.ReportFont;
import tech.grasshopper.reporter.optimizer.TextSanitizer;
import tech.grasshopper.reporter.structure.Display;
import tech.grasshopper.reporter.structure.TableCreator;

public abstract class AttributeSummaryDisplay
extends Display
implements DestinationAware {
    protected static final float NAME_HEIGHT = 25.0f;
    protected static final float HEADER_HEIGHT = 25.0f;
    protected static final float ROW_HEIGHT = 25.0f;
    protected static final float GAP_HEIGHT = 15.0f;
    protected static final int NAME_FONT_SIZE = 15;
    protected static final int HEADER_FONT_SIZE = 13;
    protected static final float BORDER_WIDTH = 1.0f;
    protected static final float HEADER_PADDING = 5.0f;
    protected static final float TABLE_PADDING = 7.0f;
    protected static final int TABLE_CONTENT_FONT_SIZE = 12;
    protected static final PDFont TABLE_CONTENT_FONT = ReportFont.REGULAR_FONT;
    protected static final float MULTILINE_SPACING = 1.0f;
    protected AttributeType type;
    protected Table.TableBuilder tableBuilder;
    private int destinationY;
    protected boolean splitRow;
    protected final TextSanitizer textSanitizer = TextSanitizer.builder().font(TABLE_CONTENT_FONT).build();

    protected Map<String, Map<Status, Integer>> contextAttributeData() {
        switch (this.type) {
            case AUTHOR: {
                return this.convertContextRowData(this.report.getAuthorCtx().getSet());
            }
            case CATEGORY: {
                return this.convertContextRowData(this.report.getCategoryCtx().getSet());
            }
            case DEVICE: {
                return this.convertContextRowData(this.report.getDeviceCtx().getSet());
            }
        }
        throw new PdfReportException("Unsupported context attribute type.");
    }

    private Map<String, Map<Status, Integer>> convertContextRowData(Set<? extends NamedAttributeContext<? extends NamedAttribute>> attributes) {
        LinkedHashMap<String, Map<Status, Integer>> data = new LinkedHashMap<String, Map<Status, Integer>>();
        attributes.forEach(a -> data.put(a.getAttr().getName(), a.getStatusDist()));
        return data;
    }

    protected Map<String, String> systemAttributeData() {
        switch (this.type) {
            case SYSTEM: {
                return this.convertSystemRowData(this.report.getSystemEnvInfo());
            }
        }
        throw new PdfReportException("Unsupported system attribute type.");
    }

    private Map<String, String> convertSystemRowData(List<? extends NameValuePair> attributes) {
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        attributes.forEach(s -> data.put(s.getName(), s.getValue()));
        return data;
    }

    protected void drawTable() {
        PDPage initialPage = this.document.getPage(this.document.getNumberOfPages() - 1);
        this.destinationY = (int)this.ylocation;
        TableCreator table = TableCreator.builder().tableBuilder(this.tableBuilder).document(this.document).startX(this.xlocation).startY(this.ylocation).repeatRows(2).splitRow(this.splitRow).build();
        table.displayTable();
        this.ylocation = table.getFinalY() - 15.0f;
        this.page = table.getTableStartPage();
        if (!initialPage.equals((Object)this.page)) {
            this.destinationY = 790;
        }
    }

    @Override
    public Destination createDestination() {
        return Destination.builder().name(this.type.toString()).yCoord(this.destinationY).page(this.page).build();
    }

    protected AttributeSummaryDisplay(AttributeSummaryDisplayBuilder<?, ?> b) {
        super(b);
        this.type = ((AttributeSummaryDisplayBuilder)b).type;
        this.tableBuilder = ((AttributeSummaryDisplayBuilder)b).tableBuilder;
        this.destinationY = ((AttributeSummaryDisplayBuilder)b).destinationY;
        this.splitRow = ((AttributeSummaryDisplayBuilder)b).splitRow;
    }

    public AttributeType getType() {
        return this.type;
    }

    public Table.TableBuilder getTableBuilder() {
        return this.tableBuilder;
    }

    public int getDestinationY() {
        return this.destinationY;
    }

    public boolean isSplitRow() {
        return this.splitRow;
    }

    public TextSanitizer getTextSanitizer() {
        return this.textSanitizer;
    }

    public void setType(AttributeType type) {
        this.type = type;
    }

    public void setTableBuilder(Table.TableBuilder tableBuilder) {
        this.tableBuilder = tableBuilder;
    }

    public void setDestinationY(int destinationY) {
        this.destinationY = destinationY;
    }

    public void setSplitRow(boolean splitRow) {
        this.splitRow = splitRow;
    }

    @Override
    public String toString() {
        return "AttributeSummaryDisplay(type=" + (Object)((Object)this.getType()) + ", tableBuilder=" + this.getTableBuilder() + ", destinationY=" + this.getDestinationY() + ", splitRow=" + this.isSplitRow() + ", textSanitizer=" + this.getTextSanitizer() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeSummaryDisplay)) {
            return false;
        }
        AttributeSummaryDisplay other = (AttributeSummaryDisplay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDestinationY() != other.getDestinationY()) {
            return false;
        }
        if (this.isSplitRow() != other.isSplitRow()) {
            return false;
        }
        AttributeType this$type = this.getType();
        AttributeType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Table.TableBuilder this$tableBuilder = this.getTableBuilder();
        Table.TableBuilder other$tableBuilder = other.getTableBuilder();
        if (this$tableBuilder == null ? other$tableBuilder != null : !this$tableBuilder.equals(other$tableBuilder)) {
            return false;
        }
        TextSanitizer this$textSanitizer = this.getTextSanitizer();
        TextSanitizer other$textSanitizer = other.getTextSanitizer();
        return !(this$textSanitizer == null ? other$textSanitizer != null : !((Object)this$textSanitizer).equals(other$textSanitizer));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AttributeSummaryDisplay;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDestinationY();
        result = result * 59 + (this.isSplitRow() ? 79 : 97);
        AttributeType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Table.TableBuilder $tableBuilder = this.getTableBuilder();
        result = result * 59 + ($tableBuilder == null ? 43 : $tableBuilder.hashCode());
        TextSanitizer $textSanitizer = this.getTextSanitizer();
        result = result * 59 + ($textSanitizer == null ? 43 : ((Object)$textSanitizer).hashCode());
        return result;
    }

    public static abstract class AttributeSummaryDisplayBuilder<C extends AttributeSummaryDisplay, B extends AttributeSummaryDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private AttributeType type;
        private Table.TableBuilder tableBuilder;
        private int destinationY;
        private boolean splitRow;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B type(AttributeType type) {
            this.type = type;
            return (B)this.self();
        }

        public B tableBuilder(Table.TableBuilder tableBuilder) {
            this.tableBuilder = tableBuilder;
            return (B)this.self();
        }

        public B destinationY(int destinationY) {
            this.destinationY = destinationY;
            return (B)this.self();
        }

        public B splitRow(boolean splitRow) {
            this.splitRow = splitRow;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "AttributeSummaryDisplay.AttributeSummaryDisplayBuilder(super=" + super.toString() + ", type=" + (Object)((Object)this.type) + ", tableBuilder=" + this.tableBuilder + ", destinationY=" + this.destinationY + ", splitRow=" + this.splitRow + ")";
        }
    }
}

