/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.config;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.reporter.configuration.AbstractConfiguration;
import java.awt.Color;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import tech.grasshopper.reporter.context.AttributeType;

public class ExtentPDFReporterConfig
extends AbstractConfiguration {
    private boolean displayAttributeSummary;
    private boolean displayAttributeDetails;
    private boolean displayTestDetails;
    private boolean displayExpandedMedia;
    private String name;
    private String nameColor;
    private String dateFormat;
    private String dateColor;
    private String startTimesColor;
    private String finishTimesColor;
    private String durationColor;
    private String passCountColor;
    private String failCountColor;
    private String passColor;
    private String failColor;
    private String skipColor;
    private String warnColor;
    private String infoColor;
    private String categoryAttributeColor;
    private String categoryNameColor;
    private String authorAttributeColor;
    private String authorNameColor;
    private String deviceAttributeColor;
    private String deviceNameColor;
    private String systemAttributeColor;
    private String systemNameColor;
    private String systemValueColor;
    private String exceptionAttributeColor;
    private String attributeTestStatusColor;
    private String testNameColor;
    private String testTimesColor;
    private String testTimeStampColor;
    private String testExceptionColor;
    private int maxCodeBlockCount;
    private int maxTableColumnCount;
    private int maxTableRowCount;
    private int testMaxIndentLevel;

    public boolean isDisplayAttributeSummary() {
        return this.displayAttributeSummary;
    }

    public boolean isDisplayAttributeDetails() {
        return this.displayAttributeDetails;
    }

    public boolean isDisplayTestDetails() {
        return this.displayTestDetails;
    }

    public boolean isDisplayExpandedMedia() {
        return this.displayExpandedMedia;
    }

    public String getReportName() {
        if (this.name == null || this.name.isEmpty()) {
            this.name = "PDF Extent Report";
        }
        return this.name;
    }

    public Color getReportNameColor() {
        return this.createColor(this.nameColor, Defaults.nameColor);
    }

    public DateTimeFormatter getReportDateFormat() {
        try {
            return DateTimeFormatter.ofPattern(this.dateFormat);
        }
        catch (Exception e) {
            return Defaults.dateFormatter;
        }
    }

    public Color getReportDateColor() {
        return this.createColor(this.dateColor, Defaults.dateColor);
    }

    public Color getStartTimesColor() {
        return this.createColor(this.startTimesColor, Defaults.startTimesColor);
    }

    public Color getFinishTimesColor() {
        return this.createColor(this.finishTimesColor, Defaults.finishTimesColor);
    }

    public Color getDurationColor() {
        return this.createColor(this.durationColor, Defaults.durationColor);
    }

    public Color getPassCountColor() {
        return this.createColor(this.passCountColor, Defaults.passCountColor);
    }

    public Color getFailCountColor() {
        return this.createColor(this.failCountColor, Defaults.failCountColor);
    }

    public Color getPassColor() {
        return this.createColor(this.passColor, Defaults.passColor);
    }

    public Color getFailColor() {
        return this.createColor(this.failColor, Defaults.failColor);
    }

    public Color getSkipColor() {
        return this.createColor(this.skipColor, Defaults.skipColor);
    }

    public Color getWarnColor() {
        return this.createColor(this.warnColor, Defaults.warnColor);
    }

    public Color getInfoColor() {
        return this.createColor(this.infoColor, Defaults.infoColor);
    }

    public Color getCategoryTitleColor() {
        return this.createColor(this.categoryAttributeColor, Defaults.categoryAttributeColor);
    }

    public Color getCategoryNameColor() {
        return this.createColor(this.categoryNameColor, Defaults.categoryNameColor);
    }

    public Color getAuthorTitleColor() {
        return this.createColor(this.authorAttributeColor, Defaults.authorAttributeColor);
    }

    public Color getAuthorNameColor() {
        return this.createColor(this.authorNameColor, Defaults.authorNameColor);
    }

    public Color getDeviceTitleColor() {
        return this.createColor(this.deviceAttributeColor, Defaults.deviceAttributeColor);
    }

    public Color getDeviceNameColor() {
        return this.createColor(this.deviceNameColor, Defaults.deviceNameColor);
    }

    public Color getSystemTitleColor() {
        return this.createColor(this.systemAttributeColor, Defaults.systemAttributeColor);
    }

    public Color getSystemNameColor() {
        return this.createColor(this.systemNameColor, Defaults.systemNameColor);
    }

    public Color getSystemValueColor() {
        return this.createColor(this.systemValueColor, Defaults.systemValueColor);
    }

    public Color getExceptionTitleColor() {
        return this.createColor(this.exceptionAttributeColor, Defaults.exceptionAttributeColor);
    }

    public Color getAttributeTestStatusColor() {
        return this.createColor(this.attributeTestStatusColor, Defaults.attributeTestStatusColor);
    }

    public Color getTestNameColor() {
        return this.createColor(this.testNameColor, Defaults.testNameColor);
    }

    public Color getTestTimesColor() {
        return this.createColor(this.testTimesColor, Defaults.testTimesColor);
    }

    public Color getTestTimeStampColor() {
        return this.createColor(this.testTimeStampColor, Defaults.testTimeStampColor);
    }

    public Color getTestExceptionColor() {
        return this.createColor(this.testExceptionColor, Defaults.testExceptionColor);
    }

    private Color createColor(String hexCode, Color defaultColor) {
        try {
            return Color.decode("#" + hexCode);
        }
        catch (Exception e) {
            return defaultColor;
        }
    }

    public int getMaxCodeBlockCount() {
        return this.maxCodeBlockCount;
    }

    public int getMaxTableColumnCount() {
        if (this.maxTableColumnCount == 0) {
            this.maxTableColumnCount = 3;
        }
        return this.maxTableColumnCount;
    }

    public int getMaxTableRowCount() {
        return this.maxTableRowCount;
    }

    public int getTestMaxIndentLevel() {
        if (this.testMaxIndentLevel == 0) {
            this.testMaxIndentLevel = 2;
        }
        return this.testMaxIndentLevel;
    }

    public Color attributeHeaderColor(AttributeType type) {
        if (type == AttributeType.CATEGORY) {
            return this.getCategoryTitleColor();
        }
        if (type == AttributeType.DEVICE) {
            return this.getDeviceTitleColor();
        }
        if (type == AttributeType.AUTHOR) {
            return this.getAuthorTitleColor();
        }
        if (type == AttributeType.EXCEPTION) {
            return this.getExceptionTitleColor();
        }
        if (type == AttributeType.SYSTEM) {
            return this.getSystemTitleColor();
        }
        return Color.RED;
    }

    public Color attributeNameColor(AttributeType type) {
        if (type == AttributeType.CATEGORY) {
            return this.getCategoryNameColor();
        }
        if (type == AttributeType.DEVICE) {
            return this.getDeviceNameColor();
        }
        if (type == AttributeType.AUTHOR) {
            return this.getAuthorNameColor();
        }
        if (type == AttributeType.SYSTEM) {
            return this.getSystemNameColor();
        }
        return Color.BLACK;
    }

    public Color statusColor(Status status) {
        if (status == Status.PASS) {
            return this.getPassColor();
        }
        if (status == Status.FAIL) {
            return this.getFailColor();
        }
        if (status == Status.SKIP) {
            return this.getSkipColor();
        }
        if (status == Status.WARNING) {
            return this.getWarnColor();
        }
        if (status == Status.INFO) {
            return this.getInfoColor();
        }
        return Color.BLACK;
    }

    private static boolean $default$displayAttributeSummary() {
        return true;
    }

    private static boolean $default$displayAttributeDetails() {
        return true;
    }

    private static boolean $default$displayTestDetails() {
        return true;
    }

    private static boolean $default$displayExpandedMedia() {
        return true;
    }

    protected ExtentPDFReporterConfig(ExtentPDFReporterConfigBuilder<?, ?> b) {
        super(b);
        this.displayAttributeSummary = ((ExtentPDFReporterConfigBuilder)b).displayAttributeSummary$set ? ((ExtentPDFReporterConfigBuilder)b).displayAttributeSummary$value : ExtentPDFReporterConfig.$default$displayAttributeSummary();
        this.displayAttributeDetails = ((ExtentPDFReporterConfigBuilder)b).displayAttributeDetails$set ? ((ExtentPDFReporterConfigBuilder)b).displayAttributeDetails$value : ExtentPDFReporterConfig.$default$displayAttributeDetails();
        this.displayTestDetails = ((ExtentPDFReporterConfigBuilder)b).displayTestDetails$set ? ((ExtentPDFReporterConfigBuilder)b).displayTestDetails$value : ExtentPDFReporterConfig.$default$displayTestDetails();
        this.displayExpandedMedia = ((ExtentPDFReporterConfigBuilder)b).displayExpandedMedia$set ? ((ExtentPDFReporterConfigBuilder)b).displayExpandedMedia$value : ExtentPDFReporterConfig.$default$displayExpandedMedia();
        this.name = ((ExtentPDFReporterConfigBuilder)b).name;
        this.nameColor = ((ExtentPDFReporterConfigBuilder)b).nameColor;
        this.dateFormat = ((ExtentPDFReporterConfigBuilder)b).dateFormat;
        this.dateColor = ((ExtentPDFReporterConfigBuilder)b).dateColor;
        this.startTimesColor = ((ExtentPDFReporterConfigBuilder)b).startTimesColor;
        this.finishTimesColor = ((ExtentPDFReporterConfigBuilder)b).finishTimesColor;
        this.durationColor = ((ExtentPDFReporterConfigBuilder)b).durationColor;
        this.passCountColor = ((ExtentPDFReporterConfigBuilder)b).passCountColor;
        this.failCountColor = ((ExtentPDFReporterConfigBuilder)b).failCountColor;
        this.passColor = ((ExtentPDFReporterConfigBuilder)b).passColor;
        this.failColor = ((ExtentPDFReporterConfigBuilder)b).failColor;
        this.skipColor = ((ExtentPDFReporterConfigBuilder)b).skipColor;
        this.warnColor = ((ExtentPDFReporterConfigBuilder)b).warnColor;
        this.infoColor = ((ExtentPDFReporterConfigBuilder)b).infoColor;
        this.categoryAttributeColor = ((ExtentPDFReporterConfigBuilder)b).categoryAttributeColor;
        this.categoryNameColor = ((ExtentPDFReporterConfigBuilder)b).categoryNameColor;
        this.authorAttributeColor = ((ExtentPDFReporterConfigBuilder)b).authorAttributeColor;
        this.authorNameColor = ((ExtentPDFReporterConfigBuilder)b).authorNameColor;
        this.deviceAttributeColor = ((ExtentPDFReporterConfigBuilder)b).deviceAttributeColor;
        this.deviceNameColor = ((ExtentPDFReporterConfigBuilder)b).deviceNameColor;
        this.systemAttributeColor = ((ExtentPDFReporterConfigBuilder)b).systemAttributeColor;
        this.systemNameColor = ((ExtentPDFReporterConfigBuilder)b).systemNameColor;
        this.systemValueColor = ((ExtentPDFReporterConfigBuilder)b).systemValueColor;
        this.exceptionAttributeColor = ((ExtentPDFReporterConfigBuilder)b).exceptionAttributeColor;
        this.attributeTestStatusColor = ((ExtentPDFReporterConfigBuilder)b).attributeTestStatusColor;
        this.testNameColor = ((ExtentPDFReporterConfigBuilder)b).testNameColor;
        this.testTimesColor = ((ExtentPDFReporterConfigBuilder)b).testTimesColor;
        this.testTimeStampColor = ((ExtentPDFReporterConfigBuilder)b).testTimeStampColor;
        this.testExceptionColor = ((ExtentPDFReporterConfigBuilder)b).testExceptionColor;
        this.maxCodeBlockCount = ((ExtentPDFReporterConfigBuilder)b).maxCodeBlockCount;
        this.maxTableColumnCount = ((ExtentPDFReporterConfigBuilder)b).maxTableColumnCount;
        this.maxTableRowCount = ((ExtentPDFReporterConfigBuilder)b).maxTableRowCount;
        this.testMaxIndentLevel = ((ExtentPDFReporterConfigBuilder)b).testMaxIndentLevel;
    }

    public static ExtentPDFReporterConfigBuilder<?, ?> builder() {
        return new ExtentPDFReporterConfigBuilderImpl();
    }

    public void setDisplayAttributeSummary(boolean displayAttributeSummary) {
        this.displayAttributeSummary = displayAttributeSummary;
    }

    public void setDisplayAttributeDetails(boolean displayAttributeDetails) {
        this.displayAttributeDetails = displayAttributeDetails;
    }

    public void setDisplayTestDetails(boolean displayTestDetails) {
        this.displayTestDetails = displayTestDetails;
    }

    public void setDisplayExpandedMedia(boolean displayExpandedMedia) {
        this.displayExpandedMedia = displayExpandedMedia;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNameColor(String nameColor) {
        this.nameColor = nameColor;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setDateColor(String dateColor) {
        this.dateColor = dateColor;
    }

    public void setStartTimesColor(String startTimesColor) {
        this.startTimesColor = startTimesColor;
    }

    public void setFinishTimesColor(String finishTimesColor) {
        this.finishTimesColor = finishTimesColor;
    }

    public void setDurationColor(String durationColor) {
        this.durationColor = durationColor;
    }

    public void setPassCountColor(String passCountColor) {
        this.passCountColor = passCountColor;
    }

    public void setFailCountColor(String failCountColor) {
        this.failCountColor = failCountColor;
    }

    public void setPassColor(String passColor) {
        this.passColor = passColor;
    }

    public void setFailColor(String failColor) {
        this.failColor = failColor;
    }

    public void setSkipColor(String skipColor) {
        this.skipColor = skipColor;
    }

    public void setWarnColor(String warnColor) {
        this.warnColor = warnColor;
    }

    public void setInfoColor(String infoColor) {
        this.infoColor = infoColor;
    }

    public void setCategoryAttributeColor(String categoryAttributeColor) {
        this.categoryAttributeColor = categoryAttributeColor;
    }

    public void setCategoryNameColor(String categoryNameColor) {
        this.categoryNameColor = categoryNameColor;
    }

    public void setAuthorAttributeColor(String authorAttributeColor) {
        this.authorAttributeColor = authorAttributeColor;
    }

    public void setAuthorNameColor(String authorNameColor) {
        this.authorNameColor = authorNameColor;
    }

    public void setDeviceAttributeColor(String deviceAttributeColor) {
        this.deviceAttributeColor = deviceAttributeColor;
    }

    public void setDeviceNameColor(String deviceNameColor) {
        this.deviceNameColor = deviceNameColor;
    }

    public void setSystemAttributeColor(String systemAttributeColor) {
        this.systemAttributeColor = systemAttributeColor;
    }

    public void setSystemNameColor(String systemNameColor) {
        this.systemNameColor = systemNameColor;
    }

    public void setSystemValueColor(String systemValueColor) {
        this.systemValueColor = systemValueColor;
    }

    public void setExceptionAttributeColor(String exceptionAttributeColor) {
        this.exceptionAttributeColor = exceptionAttributeColor;
    }

    public void setAttributeTestStatusColor(String attributeTestStatusColor) {
        this.attributeTestStatusColor = attributeTestStatusColor;
    }

    public void setTestNameColor(String testNameColor) {
        this.testNameColor = testNameColor;
    }

    public void setTestTimesColor(String testTimesColor) {
        this.testTimesColor = testTimesColor;
    }

    public void setTestTimeStampColor(String testTimeStampColor) {
        this.testTimeStampColor = testTimeStampColor;
    }

    public void setTestExceptionColor(String testExceptionColor) {
        this.testExceptionColor = testExceptionColor;
    }

    public void setMaxCodeBlockCount(int maxCodeBlockCount) {
        this.maxCodeBlockCount = maxCodeBlockCount;
    }

    public void setMaxTableColumnCount(int maxTableColumnCount) {
        this.maxTableColumnCount = maxTableColumnCount;
    }

    public void setMaxTableRowCount(int maxTableRowCount) {
        this.maxTableRowCount = maxTableRowCount;
    }

    public void setTestMaxIndentLevel(int testMaxIndentLevel) {
        this.testMaxIndentLevel = testMaxIndentLevel;
    }

    private static final class ExtentPDFReporterConfigBuilderImpl
    extends ExtentPDFReporterConfigBuilder<ExtentPDFReporterConfig, ExtentPDFReporterConfigBuilderImpl> {
        private ExtentPDFReporterConfigBuilderImpl() {
        }

        @Override
        protected ExtentPDFReporterConfigBuilderImpl self() {
            return this;
        }

        @Override
        public ExtentPDFReporterConfig build() {
            return new ExtentPDFReporterConfig(this);
        }
    }

    public static abstract class ExtentPDFReporterConfigBuilder<C extends ExtentPDFReporterConfig, B extends ExtentPDFReporterConfigBuilder<C, B>>
    extends AbstractConfiguration.AbstractConfigurationBuilder<C, B> {
        private boolean displayAttributeSummary$set;
        private boolean displayAttributeSummary$value;
        private boolean displayAttributeDetails$set;
        private boolean displayAttributeDetails$value;
        private boolean displayTestDetails$set;
        private boolean displayTestDetails$value;
        private boolean displayExpandedMedia$set;
        private boolean displayExpandedMedia$value;
        private String name;
        private String nameColor;
        private String dateFormat;
        private String dateColor;
        private String startTimesColor;
        private String finishTimesColor;
        private String durationColor;
        private String passCountColor;
        private String failCountColor;
        private String passColor;
        private String failColor;
        private String skipColor;
        private String warnColor;
        private String infoColor;
        private String categoryAttributeColor;
        private String categoryNameColor;
        private String authorAttributeColor;
        private String authorNameColor;
        private String deviceAttributeColor;
        private String deviceNameColor;
        private String systemAttributeColor;
        private String systemNameColor;
        private String systemValueColor;
        private String exceptionAttributeColor;
        private String attributeTestStatusColor;
        private String testNameColor;
        private String testTimesColor;
        private String testTimeStampColor;
        private String testExceptionColor;
        private int maxCodeBlockCount;
        private int maxTableColumnCount;
        private int maxTableRowCount;
        private int testMaxIndentLevel;

        protected abstract B self();

        public abstract C build();

        public B displayAttributeSummary(boolean displayAttributeSummary) {
            this.displayAttributeSummary$value = displayAttributeSummary;
            this.displayAttributeSummary$set = true;
            return (B)this.self();
        }

        public B displayAttributeDetails(boolean displayAttributeDetails) {
            this.displayAttributeDetails$value = displayAttributeDetails;
            this.displayAttributeDetails$set = true;
            return (B)this.self();
        }

        public B displayTestDetails(boolean displayTestDetails) {
            this.displayTestDetails$value = displayTestDetails;
            this.displayTestDetails$set = true;
            return (B)this.self();
        }

        public B displayExpandedMedia(boolean displayExpandedMedia) {
            this.displayExpandedMedia$value = displayExpandedMedia;
            this.displayExpandedMedia$set = true;
            return (B)this.self();
        }

        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        public B nameColor(String nameColor) {
            this.nameColor = nameColor;
            return (B)this.self();
        }

        public B dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return (B)this.self();
        }

        public B dateColor(String dateColor) {
            this.dateColor = dateColor;
            return (B)this.self();
        }

        public B startTimesColor(String startTimesColor) {
            this.startTimesColor = startTimesColor;
            return (B)this.self();
        }

        public B finishTimesColor(String finishTimesColor) {
            this.finishTimesColor = finishTimesColor;
            return (B)this.self();
        }

        public B durationColor(String durationColor) {
            this.durationColor = durationColor;
            return (B)this.self();
        }

        public B passCountColor(String passCountColor) {
            this.passCountColor = passCountColor;
            return (B)this.self();
        }

        public B failCountColor(String failCountColor) {
            this.failCountColor = failCountColor;
            return (B)this.self();
        }

        public B passColor(String passColor) {
            this.passColor = passColor;
            return (B)this.self();
        }

        public B failColor(String failColor) {
            this.failColor = failColor;
            return (B)this.self();
        }

        public B skipColor(String skipColor) {
            this.skipColor = skipColor;
            return (B)this.self();
        }

        public B warnColor(String warnColor) {
            this.warnColor = warnColor;
            return (B)this.self();
        }

        public B infoColor(String infoColor) {
            this.infoColor = infoColor;
            return (B)this.self();
        }

        public B categoryAttributeColor(String categoryAttributeColor) {
            this.categoryAttributeColor = categoryAttributeColor;
            return (B)this.self();
        }

        public B categoryNameColor(String categoryNameColor) {
            this.categoryNameColor = categoryNameColor;
            return (B)this.self();
        }

        public B authorAttributeColor(String authorAttributeColor) {
            this.authorAttributeColor = authorAttributeColor;
            return (B)this.self();
        }

        public B authorNameColor(String authorNameColor) {
            this.authorNameColor = authorNameColor;
            return (B)this.self();
        }

        public B deviceAttributeColor(String deviceAttributeColor) {
            this.deviceAttributeColor = deviceAttributeColor;
            return (B)this.self();
        }

        public B deviceNameColor(String deviceNameColor) {
            this.deviceNameColor = deviceNameColor;
            return (B)this.self();
        }

        public B systemAttributeColor(String systemAttributeColor) {
            this.systemAttributeColor = systemAttributeColor;
            return (B)this.self();
        }

        public B systemNameColor(String systemNameColor) {
            this.systemNameColor = systemNameColor;
            return (B)this.self();
        }

        public B systemValueColor(String systemValueColor) {
            this.systemValueColor = systemValueColor;
            return (B)this.self();
        }

        public B exceptionAttributeColor(String exceptionAttributeColor) {
            this.exceptionAttributeColor = exceptionAttributeColor;
            return (B)this.self();
        }

        public B attributeTestStatusColor(String attributeTestStatusColor) {
            this.attributeTestStatusColor = attributeTestStatusColor;
            return (B)this.self();
        }

        public B testNameColor(String testNameColor) {
            this.testNameColor = testNameColor;
            return (B)this.self();
        }

        public B testTimesColor(String testTimesColor) {
            this.testTimesColor = testTimesColor;
            return (B)this.self();
        }

        public B testTimeStampColor(String testTimeStampColor) {
            this.testTimeStampColor = testTimeStampColor;
            return (B)this.self();
        }

        public B testExceptionColor(String testExceptionColor) {
            this.testExceptionColor = testExceptionColor;
            return (B)this.self();
        }

        public B maxCodeBlockCount(int maxCodeBlockCount) {
            this.maxCodeBlockCount = maxCodeBlockCount;
            return (B)this.self();
        }

        public B maxTableColumnCount(int maxTableColumnCount) {
            this.maxTableColumnCount = maxTableColumnCount;
            return (B)this.self();
        }

        public B maxTableRowCount(int maxTableRowCount) {
            this.maxTableRowCount = maxTableRowCount;
            return (B)this.self();
        }

        public B testMaxIndentLevel(int testMaxIndentLevel) {
            this.testMaxIndentLevel = testMaxIndentLevel;
            return (B)this.self();
        }

        public String toString() {
            return "ExtentPDFReporterConfig.ExtentPDFReporterConfigBuilder(super=" + super.toString() + ", displayAttributeSummary$value=" + this.displayAttributeSummary$value + ", displayAttributeDetails$value=" + this.displayAttributeDetails$value + ", displayTestDetails$value=" + this.displayTestDetails$value + ", displayExpandedMedia$value=" + this.displayExpandedMedia$value + ", name=" + this.name + ", nameColor=" + this.nameColor + ", dateFormat=" + this.dateFormat + ", dateColor=" + this.dateColor + ", startTimesColor=" + this.startTimesColor + ", finishTimesColor=" + this.finishTimesColor + ", durationColor=" + this.durationColor + ", passCountColor=" + this.passCountColor + ", failCountColor=" + this.failCountColor + ", passColor=" + this.passColor + ", failColor=" + this.failColor + ", skipColor=" + this.skipColor + ", warnColor=" + this.warnColor + ", infoColor=" + this.infoColor + ", categoryAttributeColor=" + this.categoryAttributeColor + ", categoryNameColor=" + this.categoryNameColor + ", authorAttributeColor=" + this.authorAttributeColor + ", authorNameColor=" + this.authorNameColor + ", deviceAttributeColor=" + this.deviceAttributeColor + ", deviceNameColor=" + this.deviceNameColor + ", systemAttributeColor=" + this.systemAttributeColor + ", systemNameColor=" + this.systemNameColor + ", systemValueColor=" + this.systemValueColor + ", exceptionAttributeColor=" + this.exceptionAttributeColor + ", attributeTestStatusColor=" + this.attributeTestStatusColor + ", testNameColor=" + this.testNameColor + ", testTimesColor=" + this.testTimesColor + ", testTimeStampColor=" + this.testTimeStampColor + ", testExceptionColor=" + this.testExceptionColor + ", maxCodeBlockCount=" + this.maxCodeBlockCount + ", maxTableColumnCount=" + this.maxTableColumnCount + ", maxTableRowCount=" + this.maxTableRowCount + ", testMaxIndentLevel=" + this.testMaxIndentLevel + ")";
        }
    }

    private static class Defaults {
        private static final String name = "PDF Extent Report";
        private static final Color nameColor = Color.BLACK;
        private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM);
        private static final Color dateColor = Color.BLUE;
        private static final Color startTimesColor = Color.RED;
        private static final Color finishTimesColor = Color.RED;
        private static final Color durationColor = Color.RED;
        private static final Color passCountColor = Color.RED;
        private static final Color failCountColor = Color.RED;
        private static final Color passColor = Color.GREEN;
        private static final Color failColor = Color.RED;
        private static final Color skipColor = Color.ORANGE;
        private static final Color warnColor = Color.YELLOW;
        private static final Color infoColor = Color.BLUE;
        private static final Color categoryAttributeColor = Color.CYAN;
        private static final Color categoryNameColor = Color.BLACK;
        private static final Color authorAttributeColor = Color.MAGENTA;
        private static final Color authorNameColor = Color.BLACK;
        private static final Color deviceAttributeColor = Color.DARK_GRAY;
        private static final Color deviceNameColor = Color.BLACK;
        private static final Color systemAttributeColor = Color.YELLOW;
        private static final Color systemNameColor = Color.BLACK;
        private static final Color systemValueColor = Color.BLACK;
        private static final Color exceptionAttributeColor = Color.RED;
        private static final Color attributeTestStatusColor = Color.BLUE;
        private static final Color testNameColor = Color.RED;
        private static final Color testTimesColor = Color.BLUE;
        private static final Color testTimeStampColor = Color.BLACK;
        private static final Color testExceptionColor = Color.RED;
        private static final int maxTableColumnCount = 3;
        private static final int testMaxIndentLevel = 2;

        private Defaults() {
        }
    }
}

