/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.component.text;

import java.awt.Color;
import org.apache.pdfbox.pdmodel.font.PDFont;
import tech.grasshopper.reporter.font.ReportFont;

public class Text {
    private Color textColor;
    private PDFont font;
    private float fontSize;
    private float xlocation;
    private float ylocation;
    private String text;

    private static Color $default$textColor() {
        return Color.BLACK;
    }

    private static PDFont $default$font() {
        return ReportFont.REGULAR_FONT;
    }

    private static float $default$fontSize() {
        return 12.0f;
    }

    Text(Color textColor, PDFont font, float fontSize, float xlocation, float ylocation, String text) {
        this.textColor = textColor;
        this.font = font;
        this.fontSize = fontSize;
        this.xlocation = xlocation;
        this.ylocation = ylocation;
        this.text = text;
    }

    public static TextBuilder builder() {
        return new TextBuilder();
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public PDFont getFont() {
        return this.font;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public float getXlocation() {
        return this.xlocation;
    }

    public float getYlocation() {
        return this.ylocation;
    }

    public String getText() {
        return this.text;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public void setFont(PDFont font) {
        this.font = font;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public void setXlocation(float xlocation) {
        this.xlocation = xlocation;
    }

    public void setYlocation(float ylocation) {
        this.ylocation = ylocation;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Text)) {
            return false;
        }
        Text other = (Text)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getFontSize(), other.getFontSize()) != 0) {
            return false;
        }
        if (Float.compare(this.getXlocation(), other.getXlocation()) != 0) {
            return false;
        }
        if (Float.compare(this.getYlocation(), other.getYlocation()) != 0) {
            return false;
        }
        Color this$textColor = this.getTextColor();
        Color other$textColor = other.getTextColor();
        if (this$textColor == null ? other$textColor != null : !((Object)this$textColor).equals(other$textColor)) {
            return false;
        }
        PDFont this$font = this.getFont();
        PDFont other$font = other.getFont();
        if (this$font == null ? other$font != null : !this$font.equals(other$font)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Text;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getFontSize());
        result = result * 59 + Float.floatToIntBits(this.getXlocation());
        result = result * 59 + Float.floatToIntBits(this.getYlocation());
        Color $textColor = this.getTextColor();
        result = result * 59 + ($textColor == null ? 43 : ((Object)$textColor).hashCode());
        PDFont $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }

    public String toString() {
        return "Text(textColor=" + this.getTextColor() + ", font=" + this.getFont() + ", fontSize=" + this.getFontSize() + ", xlocation=" + this.getXlocation() + ", ylocation=" + this.getYlocation() + ", text=" + this.getText() + ")";
    }

    public static class TextBuilder {
        private boolean textColor$set;
        private Color textColor$value;
        private boolean font$set;
        private PDFont font$value;
        private boolean fontSize$set;
        private float fontSize$value;
        private float xlocation;
        private float ylocation;
        private String text;

        TextBuilder() {
        }

        public TextBuilder textColor(Color textColor) {
            this.textColor$value = textColor;
            this.textColor$set = true;
            return this;
        }

        public TextBuilder font(PDFont font) {
            this.font$value = font;
            this.font$set = true;
            return this;
        }

        public TextBuilder fontSize(float fontSize) {
            this.fontSize$value = fontSize;
            this.fontSize$set = true;
            return this;
        }

        public TextBuilder xlocation(float xlocation) {
            this.xlocation = xlocation;
            return this;
        }

        public TextBuilder ylocation(float ylocation) {
            this.ylocation = ylocation;
            return this;
        }

        public TextBuilder text(String text) {
            this.text = text;
            return this;
        }

        public Text build() {
            Color textColor$value = this.textColor$value;
            if (!this.textColor$set) {
                textColor$value = Text.$default$textColor();
            }
            PDFont font$value = this.font$value;
            if (!this.font$set) {
                font$value = Text.$default$font();
            }
            float fontSize$value = this.fontSize$value;
            if (!this.fontSize$set) {
                fontSize$value = Text.$default$fontSize();
            }
            return new Text(textColor$value, font$value, fontSize$value, this.xlocation, this.ylocation, this.text);
        }

        public String toString() {
            return "Text.TextBuilder(textColor$value=" + this.textColor$value + ", font$value=" + this.font$value + ", fontSize$value=" + this.fontSize$value + ", xlocation=" + this.xlocation + ", ylocation=" + this.ylocation + ", text=" + this.text + ")";
        }
    }
}

