/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.component.chart;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.knowm.xchart.BitmapEncoder;
import org.knowm.xchart.internal.chartpart.Chart;
import tech.grasshopper.reporter.exception.PdfReportException;

public class ChartDisplayer {
    private static final Logger logger = Logger.getLogger(ChartDisplayer.class.getName());
    private PDPageContentStream content;
    private PDDocument document;
    private Chart<?, ?> chart;
    private float xBottomLeft;
    private float yBottomLeft;

    public void display() {
        try {
            byte[] bytes = BitmapEncoder.getBitmapBytes(this.chart, (BitmapEncoder.BitmapFormat)BitmapEncoder.BitmapFormat.PNG);
            PDImageXObject pdfChartImage = PDImageXObject.createFromByteArray((PDDocument)this.document, (byte[])bytes, (String)"");
            this.content.drawImage(pdfChartImage, this.xBottomLeft, this.yBottomLeft);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "An exception occurred", e);
            throw new PdfReportException(e);
        }
    }

    protected ChartDisplayer(ChartDisplayerBuilder<?, ?> b) {
        this.content = ((ChartDisplayerBuilder)b).content;
        this.document = ((ChartDisplayerBuilder)b).document;
        this.chart = ((ChartDisplayerBuilder)b).chart;
        this.xBottomLeft = ((ChartDisplayerBuilder)b).xBottomLeft;
        this.yBottomLeft = ((ChartDisplayerBuilder)b).yBottomLeft;
    }

    public static ChartDisplayerBuilder<?, ?> builder() {
        return new ChartDisplayerBuilderImpl();
    }

    public PDPageContentStream getContent() {
        return this.content;
    }

    public PDDocument getDocument() {
        return this.document;
    }

    public Chart<?, ?> getChart() {
        return this.chart;
    }

    public float getXBottomLeft() {
        return this.xBottomLeft;
    }

    public float getYBottomLeft() {
        return this.yBottomLeft;
    }

    public void setContent(PDPageContentStream content) {
        this.content = content;
    }

    public void setDocument(PDDocument document) {
        this.document = document;
    }

    public void setChart(Chart<?, ?> chart) {
        this.chart = chart;
    }

    public void setXBottomLeft(float xBottomLeft) {
        this.xBottomLeft = xBottomLeft;
    }

    public void setYBottomLeft(float yBottomLeft) {
        this.yBottomLeft = yBottomLeft;
    }

    public String toString() {
        return "ChartDisplayer(content=" + this.getContent() + ", document=" + this.getDocument() + ", chart=" + this.getChart() + ", xBottomLeft=" + this.getXBottomLeft() + ", yBottomLeft=" + this.getYBottomLeft() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChartDisplayer)) {
            return false;
        }
        ChartDisplayer other = (ChartDisplayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getXBottomLeft(), other.getXBottomLeft()) != 0) {
            return false;
        }
        if (Float.compare(this.getYBottomLeft(), other.getYBottomLeft()) != 0) {
            return false;
        }
        PDPageContentStream this$content = this.getContent();
        PDPageContentStream other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        PDDocument this$document = this.getDocument();
        PDDocument other$document = other.getDocument();
        if (this$document == null ? other$document != null : !this$document.equals(other$document)) {
            return false;
        }
        Chart<?, ?> this$chart = this.getChart();
        Chart<?, ?> other$chart = other.getChart();
        return !(this$chart == null ? other$chart != null : !this$chart.equals(other$chart));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChartDisplayer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getXBottomLeft());
        result = result * 59 + Float.floatToIntBits(this.getYBottomLeft());
        PDPageContentStream $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        PDDocument $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : $document.hashCode());
        Chart<?, ?> $chart = this.getChart();
        result = result * 59 + ($chart == null ? 43 : $chart.hashCode());
        return result;
    }

    private static final class ChartDisplayerBuilderImpl
    extends ChartDisplayerBuilder<ChartDisplayer, ChartDisplayerBuilderImpl> {
        private ChartDisplayerBuilderImpl() {
        }

        @Override
        protected ChartDisplayerBuilderImpl self() {
            return this;
        }

        @Override
        public ChartDisplayer build() {
            return new ChartDisplayer(this);
        }
    }

    public static abstract class ChartDisplayerBuilder<C extends ChartDisplayer, B extends ChartDisplayerBuilder<C, B>> {
        private PDPageContentStream content;
        private PDDocument document;
        private Chart<?, ?> chart;
        private float xBottomLeft;
        private float yBottomLeft;

        protected abstract B self();

        public abstract C build();

        public B content(PDPageContentStream content) {
            this.content = content;
            return this.self();
        }

        public B document(PDDocument document) {
            this.document = document;
            return this.self();
        }

        public B chart(Chart<?, ?> chart) {
            this.chart = chart;
            return this.self();
        }

        public B xBottomLeft(float xBottomLeft) {
            this.xBottomLeft = xBottomLeft;
            return this.self();
        }

        public B yBottomLeft(float yBottomLeft) {
            this.yBottomLeft = yBottomLeft;
            return this.self();
        }

        public String toString() {
            return "ChartDisplayer.ChartDisplayerBuilder(content=" + this.content + ", document=" + this.document + ", chart=" + this.chart + ", xBottomLeft=" + this.xBottomLeft + ", yBottomLeft=" + this.yBottomLeft + ")";
        }
    }
}

