/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.bookmark;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import tech.grasshopper.reporter.config.ExtentPDFReporterConfig;
import tech.grasshopper.reporter.context.AttributeType;
import tech.grasshopper.reporter.destination.Destination;

public class Bookmark {
    public static final String SUMMARY_BOOKMARK_TEXT = "SUMMARY";
    public static final String DASHBOARD_BOOKMARK_TEXT = "DASHBOARD";
    public static final String ATTRIBUTES_BOOKMARK_TEXT = "ATTRIBUTES";
    public static final String TESTS_BOOKMARK_TEXT = "TESTS";
    public static final String MEDIAS_BOOKMARK_TEXT = "MEDIAS";
    private final PDDocumentOutline outline = new PDDocumentOutline();
    private Destination.DestinationStore destinationStore;
    private ExtentPDFReporterConfig config;

    public PDDocumentOutline createDocumentOutline() {
        PDOutlineItem summaryOutline = this.createSummaryOutline();
        this.createDashboardOutline(summaryOutline);
        if (this.config.isDisplayAttributeSummary()) {
            this.createAttributeSummaryOutline(summaryOutline);
        }
        if (this.config.isDisplayTestDetails()) {
            this.createTestsOutline();
        }
        if (this.config.isDisplayAttributeDetails()) {
            this.createAttributeDetailsOutline();
        }
        if (this.config.isDisplayExpandedMedia()) {
            this.createExpandedMediaOutline();
        }
        return this.outline;
    }

    private PDOutlineItem createSummaryOutline() {
        PDOutlineItem summaryOutline = this.createOutlineItem(this.destinationStore.getDashboardDestination(), SUMMARY_BOOKMARK_TEXT);
        summaryOutline.setBold(true);
        this.outline.addLast(summaryOutline);
        return summaryOutline;
    }

    private void createDashboardOutline(PDOutlineItem summaryOutline) {
        PDOutlineItem dashboardOutline = this.createOutlineItem(this.destinationStore.getDashboardDestination(), this.destinationStore.getDashboardDestination().getName());
        summaryOutline.addLast(dashboardOutline);
        summaryOutline.openNode();
    }

    private void createAttributeSummaryOutline(PDOutlineItem summaryOutline) {
        if (!this.destinationStore.getAttributeSummaryDestinations().isEmpty()) {
            PDOutlineItem attributeOutline = this.createOutlineItem(this.destinationStore.getAttributeSummaryDestinations().get(0), ATTRIBUTES_BOOKMARK_TEXT);
            summaryOutline.addLast(attributeOutline);
            for (Destination destination : this.destinationStore.getAttributeSummaryDestinations()) {
                PDOutlineItem attTypeOutline = this.createOutlineItem(destination, AttributeType.valueOf(destination.getName()).toString());
                attributeOutline.addLast(attTypeOutline);
            }
            attributeOutline.openNode();
        }
    }

    private void createExpandedMediaOutline() {
        if (!this.destinationStore.getTestMediaDestinations().isEmpty()) {
            this.outline.addLast(this.createChapterOutlineItems(this.destinationStore.getTestMediaDestinations(), MEDIAS_BOOKMARK_TEXT));
        }
    }

    private void createAttributeDetailsOutline() {
        if (!this.destinationStore.getAttributeDetailDestinations().isEmpty()) {
            PDOutlineItem attributeOutline = this.createOutlineItem(this.destinationStore.getAttributeDetailDestinations().get(0), ATTRIBUTES_BOOKMARK_TEXT);
            attributeOutline.setBold(true);
            this.outline.addLast(attributeOutline);
            Map typeDestinationMap = this.destinationStore.getAttributeDetailDestinations().stream().collect(Collectors.groupingBy(d -> {
                String name = d.getName();
                return AttributeType.valueOf(name.substring(0, name.indexOf("- ")).toUpperCase());
            }, LinkedHashMap::new, Collectors.mapping(Function.identity(), Collectors.toList())));
            typeDestinationMap.forEach((type, destinations) -> {
                PDOutlineItem attTypeOutline = this.createOutlineItem((Destination)destinations.get(0), type.toString());
                attributeOutline.addLast(attTypeOutline);
                destinations.forEach(dest -> {
                    String name = dest.getName();
                    PDOutlineItem attOutline = this.createOutlineItem((Destination)dest, name.substring(name.indexOf("- ") + 2));
                    attTypeOutline.addLast(attOutline);
                });
            });
        }
    }

    private void createTestsOutline() {
        if (!this.destinationStore.getTestDestinations().isEmpty()) {
            this.outline.addLast(this.createChapterOutlineItems(this.destinationStore.getTestDestinations(), TESTS_BOOKMARK_TEXT));
        }
    }

    private PDOutlineItem createOutlineItem(Destination destination, String title) {
        return this.createOutlineItem((PDDestination)destination.createPDPageDestination(), title);
    }

    private PDOutlineItem createOutlineItem(Destination destination) {
        return this.createOutlineItem(destination, destination.getName());
    }

    private PDOutlineItem createOutlineItem(PDDestination destination, String title) {
        PDOutlineItem bookmark = new PDOutlineItem();
        bookmark.setDestination(destination);
        bookmark.setTitle(title);
        return bookmark;
    }

    private PDOutlineItem createChapterOutlineItems(List<Destination> destinations, String title) {
        PDOutlineItem chapterBookmark = this.createOutlineItem(destinations.get(0), title);
        chapterBookmark.setBold(true);
        destinations.forEach(d -> {
            PDOutlineItem pagesBookmark = this.createOutlineItem((Destination)d);
            chapterBookmark.addLast(pagesBookmark);
        });
        return chapterBookmark;
    }

    Bookmark(Destination.DestinationStore destinationStore, ExtentPDFReporterConfig config) {
        this.destinationStore = destinationStore;
        this.config = config;
    }

    public static BookmarkBuilder builder() {
        return new BookmarkBuilder();
    }

    public PDDocumentOutline getOutline() {
        return this.outline;
    }

    public Destination.DestinationStore getDestinationStore() {
        return this.destinationStore;
    }

    public ExtentPDFReporterConfig getConfig() {
        return this.config;
    }

    public void setDestinationStore(Destination.DestinationStore destinationStore) {
        this.destinationStore = destinationStore;
    }

    public void setConfig(ExtentPDFReporterConfig config) {
        this.config = config;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bookmark)) {
            return false;
        }
        Bookmark other = (Bookmark)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PDDocumentOutline this$outline = this.getOutline();
        PDDocumentOutline other$outline = other.getOutline();
        if (this$outline == null ? other$outline != null : !this$outline.equals(other$outline)) {
            return false;
        }
        Destination.DestinationStore this$destinationStore = this.getDestinationStore();
        Destination.DestinationStore other$destinationStore = other.getDestinationStore();
        if (this$destinationStore == null ? other$destinationStore != null : !((Object)this$destinationStore).equals(other$destinationStore)) {
            return false;
        }
        ExtentPDFReporterConfig this$config = this.getConfig();
        ExtentPDFReporterConfig other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !((Object)((Object)this$config)).equals((Object)other$config));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Bookmark;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PDDocumentOutline $outline = this.getOutline();
        result = result * 59 + ($outline == null ? 43 : $outline.hashCode());
        Destination.DestinationStore $destinationStore = this.getDestinationStore();
        result = result * 59 + ($destinationStore == null ? 43 : ((Object)$destinationStore).hashCode());
        ExtentPDFReporterConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)((Object)$config)).hashCode());
        return result;
    }

    public String toString() {
        return "Bookmark(outline=" + this.getOutline() + ", destinationStore=" + this.getDestinationStore() + ", config=" + (Object)((Object)this.getConfig()) + ")";
    }

    public static class BookmarkBuilder {
        private Destination.DestinationStore destinationStore;
        private ExtentPDFReporterConfig config;

        BookmarkBuilder() {
        }

        public BookmarkBuilder destinationStore(Destination.DestinationStore destinationStore) {
            this.destinationStore = destinationStore;
            return this;
        }

        public BookmarkBuilder config(ExtentPDFReporterConfig config) {
            this.config = config;
            return this;
        }

        public Bookmark build() {
            return new Bookmark(this.destinationStore, this.config);
        }

        public String toString() {
            return "Bookmark.BookmarkBuilder(destinationStore=" + this.destinationStore + ", config=" + (Object)((Object)this.config) + ")";
        }
    }
}

