/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter;

import com.aventstack.extentreports.model.Report;
import java.io.File;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PageMode;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import tech.grasshopper.reporter.annotation.AnnotationProcessor;
import tech.grasshopper.reporter.annotation.AnnotationStore;
import tech.grasshopper.reporter.bookmark.Bookmark;
import tech.grasshopper.reporter.config.ExtentPDFReporterConfig;
import tech.grasshopper.reporter.context.AttributeSummary;
import tech.grasshopper.reporter.context.detail.AttributeDetails;
import tech.grasshopper.reporter.dashboard.Dashboard;
import tech.grasshopper.reporter.destination.Destination;
import tech.grasshopper.reporter.expanded.MediaSummary;
import tech.grasshopper.reporter.font.ReportFont;
import tech.grasshopper.reporter.header.PageHeader;
import tech.grasshopper.reporter.tests.TestDetails;

public class ReportGenerator {
    private Report report;
    private ExtentPDFReporterConfig config;
    private File reportFile;
    private PDDocument document;
    private Destination.DestinationStore destinations;
    private AnnotationStore annotations;
    private PageHeader pageHeader;

    public ReportGenerator(Report report, ExtentPDFReporterConfig config, File file) {
        this.report = report;
        this.config = config;
        this.reportFile = file;
        this.document = new PDDocument();
        this.destinations = new Destination.DestinationStore();
        this.annotations = new AnnotationStore();
        this.pageHeader = new PageHeader();
        this.loadFontFamily();
        this.createReportDirectory();
    }

    public void generate() throws IOException {
        ((Dashboard)((Dashboard.DashboardBuilder)((Dashboard.DashboardBuilder)((Dashboard.DashboardBuilder)((Dashboard.DashboardBuilder)Dashboard.builder().document(this.document)).report(this.report)).config(this.config)).destinations(this.destinations)).build()).createSection();
        if (this.config.isDisplayAttributeSummary()) {
            ((AttributeSummary)((AttributeSummary.AttributeSummaryBuilder)((AttributeSummary.AttributeSummaryBuilder)((AttributeSummary.AttributeSummaryBuilder)((AttributeSummary.AttributeSummaryBuilder)((AttributeSummary.AttributeSummaryBuilder)((AttributeSummary.AttributeSummaryBuilder)AttributeSummary.builder().document(this.document)).report(this.report)).config(this.config)).destinations(this.destinations)).annotations(this.annotations)).pageHeader(this.pageHeader)).build()).createSection();
        }
        if (this.config.isDisplayTestDetails()) {
            ((TestDetails)((TestDetails.TestDetailsBuilder)((TestDetails.TestDetailsBuilder)((TestDetails.TestDetailsBuilder)((TestDetails.TestDetailsBuilder)((TestDetails.TestDetailsBuilder)((TestDetails.TestDetailsBuilder)TestDetails.builder().document(this.document)).report(this.report)).config(this.config)).destinations(this.destinations)).annotations(this.annotations)).pageHeader(this.pageHeader)).build()).createSection();
        }
        if (this.config.isDisplayAttributeDetails()) {
            ((AttributeDetails)((AttributeDetails.AttributeDetailsBuilder)((AttributeDetails.AttributeDetailsBuilder)((AttributeDetails.AttributeDetailsBuilder)((AttributeDetails.AttributeDetailsBuilder)((AttributeDetails.AttributeDetailsBuilder)((AttributeDetails.AttributeDetailsBuilder)AttributeDetails.builder().document(this.document)).report(this.report)).config(this.config)).destinations(this.destinations)).annotations(this.annotations)).pageHeader(this.pageHeader)).build()).createSection();
        }
        if (this.config.isDisplayExpandedMedia()) {
            ((MediaSummary)((MediaSummary.MediaSummaryBuilder)((MediaSummary.MediaSummaryBuilder)((MediaSummary.MediaSummaryBuilder)((MediaSummary.MediaSummaryBuilder)((MediaSummary.MediaSummaryBuilder)((MediaSummary.MediaSummaryBuilder)MediaSummary.builder().document(this.document)).report(this.report)).config(this.config)).destinations(this.destinations)).annotations(this.annotations)).pageHeader(this.pageHeader)).build()).createSection();
        }
        AnnotationProcessor.builder().annotations(this.annotations).destinations(this.destinations).config(this.config).build().processAnnotations();
        Bookmark bookmark = Bookmark.builder().destinationStore(this.destinations).config(this.config).build();
        PDDocumentOutline outline = bookmark.createDocumentOutline();
        this.document.getDocumentCatalog().setDocumentOutline(outline);
        this.document.getDocumentCatalog().setPageMode(PageMode.USE_OUTLINES);
        this.document.save(this.reportFile);
        this.document.close();
    }

    private void loadFontFamily() {
        ReportFont reportFont = new ReportFont(this.document);
        reportFont.loadReportFontFamily();
    }

    private void createReportDirectory() {
        File dir = new File(this.reportFile.getParent());
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }
}

