/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter;

import com.aventstack.extentreports.config.external.JsonConfigLoader;
import com.aventstack.extentreports.config.external.XmlConfigLoader;
import com.aventstack.extentreports.model.Report;
import com.aventstack.extentreports.observer.ReportObserver;
import com.aventstack.extentreports.observer.entity.ReportEntity;
import com.aventstack.extentreports.reporter.AbstractFileReporter;
import com.aventstack.extentreports.reporter.AbstractReporter;
import com.aventstack.extentreports.reporter.ReporterConfigurable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import tech.grasshopper.reporter.ReportGenerator;
import tech.grasshopper.reporter.config.ExtentPDFReporterConfig;

public class ExtentPDFReporter
extends AbstractFileReporter
implements ReportObserver<ReportEntity>,
ReporterConfigurable {
    private static final Logger logger = Logger.getLogger(ExtentPDFReporter.class.getName());
    private static final String REPORTER_NAME = "pdf";
    private static final String FILE_NAME = "Index.pdf";
    private Disposable disposable;
    private Report report;
    private ExtentPDFReporterConfig config = ((ExtentPDFReporterConfig.ExtentPDFReporterConfigBuilder)ExtentPDFReporterConfig.builder().reporter((AbstractReporter)this)).build();

    public ExtentPDFReporter(String path) {
        super(new File(path));
    }

    public ExtentPDFReporter(File f) {
        super(f);
    }

    public ExtentPDFReporterConfig config() {
        return this.config;
    }

    public ExtentPDFReporter config(ExtentPDFReporterConfig conf) {
        conf.setReporter((AbstractReporter)this);
        this.config = conf;
        return this;
    }

    public void loadJSONConfig(File jsonFile) throws IOException {
        JsonConfigLoader loader = new JsonConfigLoader((Object)this.config, jsonFile);
        loader.apply();
    }

    public void loadJSONConfig(String jsonString) throws IOException {
        JsonConfigLoader loader = new JsonConfigLoader((Object)this.config, jsonString);
        loader.apply();
    }

    public void loadXMLConfig(File xmlFile) throws IOException {
        XmlConfigLoader loader = new XmlConfigLoader((Object)this.config, xmlFile);
        loader.apply();
    }

    public void loadXMLConfig(String xmlFile) throws IOException {
        this.loadXMLConfig(new File(xmlFile));
    }

    public Observer<ReportEntity> getReportObserver() {
        return new Observer<ReportEntity>(){

            public void onSubscribe(Disposable d) {
                ExtentPDFReporter.this.start(d);
            }

            public void onNext(ReportEntity value) {
                ExtentPDFReporter.this.flush(value);
            }

            public void onError(Throwable e) {
            }

            public void onComplete() {
            }
        };
    }

    private void start(Disposable d) {
        this.disposable = d;
    }

    private void flush(ReportEntity value) {
        try {
            this.report = value.getReport();
            String filePath = this.getFileNameAsExt(FILE_NAME, new String[]{".pdf"});
            ReportGenerator reportGenerator = new ReportGenerator(this.report, this.config, new File(filePath));
            reportGenerator.generate();
        }
        catch (Exception e) {
            this.disposable.dispose();
            logger.log(Level.SEVERE, "An exception occurred", e);
        }
    }
}

