/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.shaded.gherkin.messages.internal.gherkin;

import io.cucumber.shaded.gherkin.messages.internal.gherkin.GherkinLineSpan;
import io.cucumber.shaded.gherkin.messages.internal.gherkin.IGherkinLine;
import io.cucumber.shaded.gherkin.messages.internal.gherkin.Location;
import io.cucumber.shaded.gherkin.messages.internal.gherkin.ParserException;
import io.cucumber.shaded.gherkin.messages.internal.gherkin.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.PrimitiveIterator;

public class GherkinLine
implements IGherkinLine {
    private static final int OFFSET = 1;
    private final String lineText;
    private final String trimmedLineText;
    private final int indent;
    private final int line;

    public GherkinLine(String lineText, int line) {
        this.lineText = lineText;
        this.trimmedLineText = StringUtils.trim(lineText);
        this.line = line;
        this.indent = StringUtils.symbolCount(lineText) - StringUtils.symbolCount(StringUtils.ltrim(lineText));
    }

    @Override
    public int indent() {
        return this.indent;
    }

    @Override
    public void detach() {
    }

    @Override
    public String getLineText(int indentToRemove) {
        if (indentToRemove < 0 || indentToRemove > this.indent()) {
            return this.trimmedLineText;
        }
        return this.lineText.substring(indentToRemove);
    }

    @Override
    public boolean isEmpty() {
        return this.trimmedLineText.length() == 0;
    }

    @Override
    public boolean startsWith(String prefix) {
        return this.trimmedLineText.startsWith(prefix);
    }

    @Override
    public String getRestTrimmed(int length) {
        return this.trimmedLineText.substring(length).trim();
    }

    @Override
    public List<GherkinLineSpan> getTags() {
        String[] elements;
        String uncommentedLine = this.trimmedLineText.split("\\s#", 2)[0];
        ArrayList<GherkinLineSpan> tags = new ArrayList<GherkinLineSpan>();
        int indexInUncommentedLine = 0;
        for (String element : elements = uncommentedLine.split("@")) {
            String token = StringUtils.rtrim(element);
            if (token.isEmpty()) continue;
            int symbolLength = uncommentedLine.codePointCount(0, indexInUncommentedLine);
            int column = this.indent() + symbolLength + 1;
            if (!token.matches("^\\S+$")) {
                throw new ParserException("A tag may not contain whitespace", new Location(this.line, column));
            }
            tags.add(new GherkinLineSpan(column, "@" + token));
            indexInUncommentedLine += element.length() + 1;
        }
        return tags;
    }

    @Override
    public List<GherkinLineSpan> getTableCells() {
        ArrayList<GherkinLineSpan> lineSpans = new ArrayList<GherkinLineSpan>();
        StringBuilder cellBuilder = new StringBuilder();
        boolean beforeFirst = true;
        int col = 0;
        int cellStart = 0;
        boolean escape = false;
        PrimitiveIterator.OfInt iterator = this.lineText.codePoints().iterator();
        while (iterator.hasNext()) {
            int c = iterator.next();
            if (escape) {
                switch (c) {
                    case 110: {
                        cellBuilder.append('\n');
                        break;
                    }
                    case 92: {
                        cellBuilder.append('\\');
                        break;
                    }
                    case 124: {
                        cellBuilder.append('|');
                        break;
                    }
                    default: {
                        cellBuilder.append("\\");
                        cellBuilder.appendCodePoint(c);
                    }
                }
                escape = false;
            } else if (c == 92) {
                escape = true;
            } else if (c == 124) {
                if (beforeFirst) {
                    beforeFirst = false;
                } else {
                    String cell = cellBuilder.toString();
                    String leftTrimmedCell = StringUtils.ltrimKeepNewLines(cell);
                    int cellIndent = StringUtils.symbolCount(cell) - StringUtils.symbolCount(leftTrimmedCell);
                    lineSpans.add(new GherkinLineSpan(cellStart + cellIndent + 1, StringUtils.rtrimKeepNewLines(leftTrimmedCell)));
                }
                cellBuilder = new StringBuilder();
                cellStart = col + 1;
            } else {
                cellBuilder.appendCodePoint(c);
            }
            ++col;
        }
        return lineSpans;
    }

    @Override
    public boolean startsWithTitleKeyword(String text) {
        int textLength = text.length();
        return this.trimmedLineText.length() > textLength && this.trimmedLineText.startsWith(text) && this.trimmedLineText.substring(textLength, textLength + ":".length()).equals(":");
    }
}

