/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.extent.data.generator;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import tech.grasshopper.extent.data.SheetData;
import tech.grasshopper.extent.data.generator.AttributeDataPopulator;
import tech.grasshopper.extent.data.pojo.Feature;
import tech.grasshopper.extent.data.pojo.Scenario;
import tech.grasshopper.extent.data.pojo.Status;

public class TagDataPopulator
extends AttributeDataPopulator {
    public void populateFailAndSkipScenariosTagCountData(List<SheetData.AttributeCountData> failSkipTagData) {
        List<Feature> statusFailAndSkippedFeatures = this.features.stream().filter(f -> f.getStatus() != Status.PASSED).collect(Collectors.toList());
        this.populateAttributeCountData(failSkipTagData, statusFailAndSkippedFeatures);
        this.removeTagsWithOnlyPassedScenarios(failSkipTagData);
    }

    private void removeTagsWithOnlyPassedScenarios(List<SheetData.AttributeCountData> tagData) {
        tagData.removeIf(td -> td.getScenarioCounts().getPassed() == td.getScenarioCounts().getTotal());
    }

    public void populateFailSkipFeatureScenarioData(Map<String, List<Feature>> data) {
        for (Feature feature : this.features) {
            if (feature.getStatus() == Status.PASSED) continue;
            for (Scenario scenario : feature.getScenarios()) {
                if (scenario.getStatus() == Status.PASSED) continue;
                this.populateAttributeFeatureScenarioData(data, feature, scenario);
            }
        }
    }

    @Override
    protected List<String> getAttributeNames(Scenario scenario) {
        return scenario.getTags();
    }

    protected TagDataPopulator(TagDataPopulatorBuilder<?, ?> b) {
        super(b);
    }

    public static TagDataPopulatorBuilder<?, ?> builder() {
        return new TagDataPopulatorBuilderImpl();
    }

    private static final class TagDataPopulatorBuilderImpl
    extends TagDataPopulatorBuilder<TagDataPopulator, TagDataPopulatorBuilderImpl> {
        private TagDataPopulatorBuilderImpl() {
        }

        @Override
        protected TagDataPopulatorBuilderImpl self() {
            return this;
        }

        @Override
        public TagDataPopulator build() {
            return new TagDataPopulator(this);
        }
    }

    public static abstract class TagDataPopulatorBuilder<C extends TagDataPopulator, B extends TagDataPopulatorBuilder<C, B>>
    extends AttributeDataPopulator.AttributeDataPopulatorBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "TagDataPopulator.TagDataPopulatorBuilder(super=" + super.toString() + ")";
        }
    }
}

