/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.extent.data.generator;

import java.time.Duration;
import java.util.List;
import tech.grasshopper.extent.data.SheetData;
import tech.grasshopper.extent.data.pojo.Feature;
import tech.grasshopper.extent.data.pojo.Scenario;

public class NonExecutableDataPopulator {
    private List<Feature> features;

    public void populateFeatureData(List<SheetData.FeatureData> featureData) {
        for (Feature feature : this.features) {
            SheetData.TimingData timingData = SheetData.TimingData.builder().startTime(feature.getStartTime()).endTime(feature.getEndTime()).duration(Duration.between(feature.getStartTime(), feature.getEndTime())).build();
            SheetData.CountData scenarioCounts = SheetData.CountData.builder().total(feature.getTotalScenarios()).passed(feature.getPassedScenarios()).failed(feature.getFailedScenarios()).skipped(feature.getSkippedScenarios()).build();
            SheetData.CountData stepCounts = SheetData.CountData.builder().total(feature.getTotalSteps()).passed(feature.getPassedSteps()).failed(feature.getFailedSteps()).skipped(feature.getSkippedSteps()).build();
            featureData.add(SheetData.FeatureData.builder().name(feature.getName()).status(feature.getStatus()).timingData(timingData).scenarioCounts(scenarioCounts).stepCounts(stepCounts).build());
        }
    }

    public void populateScenarioData(List<SheetData.ScenarioData> scenarioData) {
        for (Feature feature : this.features) {
            for (Scenario scenario : feature.getScenarios()) {
                SheetData.TimingData timingData = SheetData.TimingData.builder().startTime(scenario.getStartTime()).endTime(scenario.getEndTime()).duration(Duration.between(scenario.getStartTime(), scenario.getEndTime())).build();
                SheetData.CountData stepCounts = SheetData.CountData.builder().total(scenario.getTotalSteps()).passed(scenario.getPassedSteps()).failed(scenario.getFailedSteps()).skipped(scenario.getSkippedSteps()).build();
                scenarioData.add(SheetData.ScenarioData.builder().name(scenario.getName()).status(scenario.getStatus()).featureName(feature.getName()).featureStatus(feature.getStatus()).timingData(timingData).stepCounts(stepCounts).build());
            }
        }
    }

    NonExecutableDataPopulator(List<Feature> features) {
        this.features = features;
    }

    public static NonExecutableDataPopulatorBuilder builder() {
        return new NonExecutableDataPopulatorBuilder();
    }

    public static class NonExecutableDataPopulatorBuilder {
        private List<Feature> features;

        NonExecutableDataPopulatorBuilder() {
        }

        public NonExecutableDataPopulatorBuilder features(List<Feature> features) {
            this.features = features;
            return this;
        }

        public NonExecutableDataPopulator build() {
            return new NonExecutableDataPopulator(this.features);
        }

        public String toString() {
            return "NonExecutableDataPopulator.NonExecutableDataPopulatorBuilder(features=" + this.features + ")";
        }
    }
}

