/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.excel.report.sheets.scenarios;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import tech.grasshopper.excel.report.cell.ValueOption;
import tech.grasshopper.excel.report.chart.ChartOperations;
import tech.grasshopper.excel.report.sheets.Sheet;
import tech.grasshopper.excel.report.table.SimpleTableOperations;
import tech.grasshopper.excel.report.util.DateUtil;
import tech.grasshopper.extent.data.SheetData;

public class ScenariosSheet
extends Sheet {
    private static final String SCENARIOS_TABLE_NAME_CELL = "B22";
    private static final String SCENARIOS_TABLE_STEP_PASSED_CELL = "H22";
    private static final String SCENARIOS_TABLE_STEP_FAILED_CELL = "I22";
    private static final String SCENARIOS_TABLE_STEP_SKIPPED_CELL = "J22";
    private static final String SCENARIOS_CHART = "Scenarios";

    @Override
    public void updateSheet() {
        this.sheet = this.workbook.getSheet(SCENARIOS_CHART);
        if (this.reportData.getScenarioData().isEmpty()) {
            this.deleteSheet(SCENARIOS_CHART);
            return;
        }
        this.updateScenariosTableData();
        this.refreshScenariosChartPlot();
        this.sheet.createFreezePane(0, 21);
    }

    private void updateScenariosTableData() {
        SimpleTableOperations<SheetData.ScenarioData> scenarioTableOperations = SimpleTableOperations.builder().sheet(this.sheet).build();
        Function<SheetData.ScenarioData, List> rowValueTransformer = s -> {
            ArrayList<String> row = new ArrayList<String>();
            SheetData.CountData counts = s.getStepCounts();
            row.add(s.getName());
            row.add(s.getStatus().toString());
            row.add(DateUtil.durationValue(s.getTimingData().getDuration()));
            row.add(s.getFeatureName());
            row.add(s.getFeatureStatus().toString());
            row.add(String.valueOf(counts.getTotal()));
            row.add(String.valueOf(counts.getPassed()));
            row.add(String.valueOf(counts.getFailed()));
            row.add(String.valueOf(counts.getSkipped()));
            return row;
        };
        ArrayList<String> styles = new ArrayList<String>();
        styles.add("BOLD_CELL_STYLE");
        styles.add("STATUS_TEXT_BOLD_CELL_STYLE");
        styles.add("ITALIC_CELL_STYLE");
        styles.add("BOLD_CELL_STYLE");
        styles.add("STATUS_TEXT_BOLD_CELL_STYLE");
        styles.add("HORIZONTAL_CENTER_CELL_OPTIONS");
        styles.add("PASS_TEXTCOLOR_HORIZONTAL_CENTER_CELL_STYLE");
        styles.add("FAIL_TEXTCOLOR_HORIZONTAL_CENTER_CELL_STYLE");
        styles.add("SKIP_TEXTCOLOR_HORIZONTAL_CENTER_CELL_STYLE");
        ArrayList<ValueOption> options = new ArrayList<ValueOption>();
        options.add(ValueOption.VALUE);
        options.add(ValueOption.STATUS_TEXT);
        options.add(ValueOption.VALUE);
        options.add(ValueOption.VALUE);
        options.add(ValueOption.STATUS_TEXT);
        options.add(ValueOption.POSITIVE_NUMBER);
        options.add(ValueOption.POSITIVE_NUMBER);
        options.add(ValueOption.POSITIVE_NUMBER);
        options.add(ValueOption.POSITIVE_NUMBER);
        scenarioTableOperations.writeTableCellValues(SCENARIOS_TABLE_NAME_CELL, this.reportData.getScenarioData(), rowValueTransformer, styles, options);
    }

    private void refreshScenariosChartPlot() {
        ChartOperations chartOperations = ChartOperations.builder().dataSheet(this.sheet).chartSheet(this.sheet).build();
        int rows = this.reportData.getScenarioData().size();
        ChartOperations.ChartDataSeriesRange categoryRange = ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange(SCENARIOS_TABLE_NAME_CELL, rows);
        ArrayList<ChartOperations.ChartDataSeriesRange> valueRanges = new ArrayList<ChartOperations.ChartDataSeriesRange>();
        valueRanges.add(ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange(SCENARIOS_TABLE_STEP_PASSED_CELL, rows));
        valueRanges.add(ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange(SCENARIOS_TABLE_STEP_SKIPPED_CELL, rows));
        valueRanges.add(ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange(SCENARIOS_TABLE_STEP_FAILED_CELL, rows));
        chartOperations.updateBarChartPlot(SCENARIOS_CHART, categoryRange, valueRanges);
    }

    protected ScenariosSheet(ScenariosSheetBuilder<?, ?> b) {
        super(b);
    }

    public static ScenariosSheetBuilder<?, ?> builder() {
        return new ScenariosSheetBuilderImpl();
    }

    private static final class ScenariosSheetBuilderImpl
    extends ScenariosSheetBuilder<ScenariosSheet, ScenariosSheetBuilderImpl> {
        private ScenariosSheetBuilderImpl() {
        }

        @Override
        protected ScenariosSheetBuilderImpl self() {
            return this;
        }

        @Override
        public ScenariosSheet build() {
            return new ScenariosSheet(this);
        }
    }

    public static abstract class ScenariosSheetBuilder<C extends ScenariosSheet, B extends ScenariosSheetBuilder<C, B>>
    extends Sheet.SheetBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "ScenariosSheet.ScenariosSheetBuilder(super=" + super.toString() + ")";
        }
    }
}

