/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.excel.report.sheets.features;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import tech.grasshopper.excel.report.cell.ValueOption;
import tech.grasshopper.excel.report.chart.ChartOperations;
import tech.grasshopper.excel.report.sheets.Sheet;
import tech.grasshopper.excel.report.table.SimpleTableOperations;
import tech.grasshopper.excel.report.util.DateUtil;
import tech.grasshopper.extent.data.SheetData;

public class FeaturesSheet
extends Sheet {
    private static final String FEATURES_TABLE_NAME_CELL = "B22";
    private static final String FEATURES_TABLE_SCENARIO_PASSED_CELL = "F22";
    private static final String FEATURES_TABLE_SCENARIO_FAILED_CELL = "G22";
    private static final String FEATURES_TABLE_SCENARIO_SKIPPED_CELL = "H22";
    private static final String FEATURES_CHART = "Features";

    @Override
    public void updateSheet() {
        this.sheet = this.workbook.getSheet(FEATURES_CHART);
        if (this.reportData.getFeatureData().isEmpty()) {
            this.deleteSheet(FEATURES_CHART);
            return;
        }
        this.updateFeaturesTableData();
        this.refreshFeaturesChartPlot();
        this.sheet.createFreezePane(0, 21);
    }

    private void updateFeaturesTableData() {
        SimpleTableOperations<SheetData.FeatureData> featureTableOperations = SimpleTableOperations.builder().sheet(this.sheet).build();
        Function<SheetData.FeatureData, List> rowValueTransformer = f -> {
            ArrayList<String> row = new ArrayList<String>();
            SheetData.CountData scenarioCounts = f.getScenarioCounts();
            SheetData.CountData stepCounts = f.getStepCounts();
            row.add(f.getName());
            row.add(f.getStatus().toString());
            row.add(DateUtil.durationValue(f.getTimingData().getDuration()));
            row.add(String.valueOf(scenarioCounts.getTotal()));
            row.add(String.valueOf(scenarioCounts.getPassed()));
            row.add(String.valueOf(scenarioCounts.getFailed()));
            row.add(String.valueOf(scenarioCounts.getSkipped()));
            row.add(scenarioCounts.getPassPercent());
            row.add(String.valueOf(stepCounts.getTotal()));
            row.add(String.valueOf(stepCounts.getPassed()));
            row.add(String.valueOf(stepCounts.getFailed()));
            row.add(String.valueOf(stepCounts.getSkipped()));
            return row;
        };
        ArrayList<String> styles = new ArrayList<String>();
        styles.add("BOLD_CELL_STYLE");
        styles.add("STATUS_TEXT_BOLD_CELL_STYLE");
        styles.add("ITALIC_CELL_STYLE");
        styles.add("HORIZONTAL_CENTER_CELL_OPTIONS");
        styles.add("PASS_TEXTCOLOR_HORIZONTAL_CENTER_CELL_STYLE");
        styles.add("FAIL_TEXTCOLOR_HORIZONTAL_CENTER_CELL_STYLE");
        styles.add("SKIP_TEXTCOLOR_HORIZONTAL_CENTER_CELL_STYLE");
        styles.add("BOLD_HORIZONTAL_CENTER_CELL_OPTIONS");
        styles.add("HORIZONTAL_CENTER_CELL_OPTIONS");
        styles.add("PASS_TEXTCOLOR_HORIZONTAL_CENTER_CELL_STYLE");
        styles.add("FAIL_TEXTCOLOR_HORIZONTAL_CENTER_CELL_STYLE");
        styles.add("SKIP_TEXTCOLOR_HORIZONTAL_CENTER_CELL_STYLE");
        ArrayList<ValueOption> options = new ArrayList<ValueOption>();
        options.add(ValueOption.VALUE);
        options.add(ValueOption.STATUS_TEXT);
        options.add(ValueOption.VALUE);
        options.add(ValueOption.POSITIVE_NUMBER);
        options.add(ValueOption.POSITIVE_NUMBER);
        options.add(ValueOption.POSITIVE_NUMBER);
        options.add(ValueOption.POSITIVE_NUMBER);
        options.add(ValueOption.VALUE);
        options.add(ValueOption.POSITIVE_NUMBER);
        options.add(ValueOption.POSITIVE_NUMBER);
        options.add(ValueOption.POSITIVE_NUMBER);
        options.add(ValueOption.POSITIVE_NUMBER);
        featureTableOperations.writeTableCellValues(FEATURES_TABLE_NAME_CELL, this.reportData.getFeatureData(), rowValueTransformer, styles, options);
    }

    private void refreshFeaturesChartPlot() {
        ChartOperations chartOperations = ChartOperations.builder().dataSheet(this.sheet).chartSheet(this.sheet).build();
        int rows = this.reportData.getFeatureData().size();
        ChartOperations.ChartDataSeriesRange categoryRange = ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange(FEATURES_TABLE_NAME_CELL, rows);
        ArrayList<ChartOperations.ChartDataSeriesRange> valueRanges = new ArrayList<ChartOperations.ChartDataSeriesRange>();
        valueRanges.add(ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange(FEATURES_TABLE_SCENARIO_PASSED_CELL, rows));
        valueRanges.add(ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange(FEATURES_TABLE_SCENARIO_SKIPPED_CELL, rows));
        valueRanges.add(ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange(FEATURES_TABLE_SCENARIO_FAILED_CELL, rows));
        chartOperations.updateBarChartPlot(FEATURES_CHART, categoryRange, valueRanges);
    }

    protected FeaturesSheet(FeaturesSheetBuilder<?, ?> b) {
        super(b);
    }

    public static FeaturesSheetBuilder<?, ?> builder() {
        return new FeaturesSheetBuilderImpl();
    }

    private static final class FeaturesSheetBuilderImpl
    extends FeaturesSheetBuilder<FeaturesSheet, FeaturesSheetBuilderImpl> {
        private FeaturesSheetBuilderImpl() {
        }

        @Override
        protected FeaturesSheetBuilderImpl self() {
            return this;
        }

        @Override
        public FeaturesSheet build() {
            return new FeaturesSheet(this);
        }
    }

    public static abstract class FeaturesSheetBuilder<C extends FeaturesSheet, B extends FeaturesSheetBuilder<C, B>>
    extends Sheet.SheetBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "FeaturesSheet.FeaturesSheetBuilder(super=" + super.toString() + ")";
        }
    }
}

