/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.excel.report.sheets.attributes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.poi.ss.util.CellReference;
import tech.grasshopper.excel.report.cell.ValueOption;
import tech.grasshopper.excel.report.chart.ChartOperations;
import tech.grasshopper.excel.report.sheets.ComponentShifter;
import tech.grasshopper.excel.report.sheets.Sheet;
import tech.grasshopper.excel.report.table.AttributeFeatureScenarioTable;
import tech.grasshopper.excel.report.table.SimpleTableOperations;
import tech.grasshopper.extent.data.SheetData;
import tech.grasshopper.extent.data.pojo.Feature;

public abstract class AttributesSheet
extends Sheet {
    private static final String ATTRIBUTES_COUNT_TABLE_NAME_CELL = "B22";
    private static final String ATTRIBUTES_COUNT_TABLE_SCENARIO_PASSED_CELL = "D22";
    private static final String ATTRIBUTES_COUNT_TABLE_SCENARIO_FAILED_CELL = "E22";
    private static final String ATTRIBUTES_COUNT_TABLE_SCENARIO_SKIPPED_CELL = "F22";
    private static final String ATTRIBUTES_TABLE_NAME_CELL = "B26";

    @Override
    public void updateSheet() {
        this.sheet = this.workbook.getSheet(this.getAttributeSheetName());
        if (this.getAttributeCountData().isEmpty()) {
            this.deleteSheet(this.getAttributeSheetName());
            return;
        }
        this.moveDownAttributesFeatureScenarioTable();
        this.updateAttributesTableData();
        this.refreshAtributesChartPlot();
        CellReference origCellRef = new CellReference(ATTRIBUTES_TABLE_NAME_CELL);
        CellReference cellRef = new CellReference(origCellRef.getRow() + this.getAttributeCountData().size(), origCellRef.getCol());
        this.updateAttributesFeatureScenarioTableData(cellRef);
        this.sheet.createFreezePane(0, 21);
    }

    private void moveDownAttributesFeatureScenarioTable() {
        CellReference celRef = new CellReference(ATTRIBUTES_COUNT_TABLE_NAME_CELL);
        ComponentShifter.shiftRows(this.sheet, celRef.getRow() + 1, this.getAttributeCountData().size());
    }

    private void updateAttributesTableData() {
        SimpleTableOperations<SheetData.AttributeCountData> scenarioTableOperations = SimpleTableOperations.builder().sheet(this.sheet).build();
        Function<SheetData.AttributeCountData, List> rowValueTransformer = t -> {
            ArrayList<String> row = new ArrayList<String>();
            SheetData.CountData counts = t.getScenarioCounts();
            row.add(t.getName());
            row.add(String.valueOf(counts.getTotal()));
            row.add(String.valueOf(counts.getPassed()));
            row.add(String.valueOf(counts.getFailed()));
            row.add(String.valueOf(counts.getSkipped()));
            row.add(counts.getPassPercent());
            return row;
        };
        ArrayList<String> styles = new ArrayList<String>();
        styles.add("BOLD_CELL_STYLE");
        styles.add("HORIZONTAL_CENTER_CELL_OPTIONS");
        styles.add("PASS_TEXTCOLOR_HORIZONTAL_CENTER_CELL_STYLE");
        styles.add("FAIL_TEXTCOLOR_HORIZONTAL_CENTER_CELL_STYLE");
        styles.add("SKIP_TEXTCOLOR_HORIZONTAL_CENTER_CELL_STYLE");
        styles.add("BOLD_HORIZONTAL_CENTER_CELL_OPTIONS");
        ArrayList<ValueOption> options = new ArrayList<ValueOption>();
        options.add(ValueOption.VALUE);
        options.add(ValueOption.POSITIVE_NUMBER);
        options.add(ValueOption.POSITIVE_NUMBER);
        options.add(ValueOption.POSITIVE_NUMBER);
        options.add(ValueOption.POSITIVE_NUMBER);
        options.add(ValueOption.VALUE);
        scenarioTableOperations.writeTableCellValues(ATTRIBUTES_COUNT_TABLE_NAME_CELL, this.getAttributeCountData(), rowValueTransformer, styles, options);
    }

    private void refreshAtributesChartPlot() {
        ChartOperations chartOperations = ChartOperations.builder().dataSheet(this.sheet).chartSheet(this.sheet).build();
        int rows = this.getAttributeCountData().size();
        ChartOperations.ChartDataSeriesRange categoryRange = ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange(ATTRIBUTES_COUNT_TABLE_NAME_CELL, rows);
        ArrayList<ChartOperations.ChartDataSeriesRange> valueRanges = new ArrayList<ChartOperations.ChartDataSeriesRange>();
        valueRanges.add(ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange(ATTRIBUTES_COUNT_TABLE_SCENARIO_PASSED_CELL, rows));
        valueRanges.add(ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange(ATTRIBUTES_COUNT_TABLE_SCENARIO_SKIPPED_CELL, rows));
        valueRanges.add(ChartOperations.ChartDataSeriesRange.convertCellReferenceToChartDataRange(ATTRIBUTES_COUNT_TABLE_SCENARIO_FAILED_CELL, rows));
        chartOperations.updateBarChartPlot(this.getAttributeChartName(), categoryRange, valueRanges);
    }

    private void updateAttributesFeatureScenarioTableData(CellReference cellReference) {
        AttributeFeatureScenarioTable.builder().featureAndScenarioAttributeData(this.getFeatureScenarioAttributeData()).sheet(this.sheet).startCell(cellReference.formatAsString()).columnCellCount(new int[]{1, 5, 1, 1}).build().writeTableValues();
    }

    protected abstract List<SheetData.AttributeCountData> getAttributeCountData();

    protected abstract String getAttributeSheetName();

    protected abstract String getAttributeChartName();

    protected abstract Map<String, List<Feature>> getFeatureScenarioAttributeData();

    protected AttributesSheet(AttributesSheetBuilder<?, ?> b) {
        super(b);
    }

    public static abstract class AttributesSheetBuilder<C extends AttributesSheet, B extends AttributesSheetBuilder<C, B>>
    extends Sheet.SheetBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "AttributesSheet.AttributesSheetBuilder(super=" + super.toString() + ")";
        }
    }
}

