/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.excel.report.cell;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import tech.grasshopper.excel.report.cell.CellStyles;
import tech.grasshopper.excel.report.cell.ValueOption;
import tech.grasshopper.extent.data.pojo.Status;

public class CellOperations {
    private XSSFSheet sheet;

    public void writePlainValue(String cellName, String cellValue) {
        CellReference cellReference = new CellReference(cellName);
        Cell cell = this.fetchOrCreateCell(cellReference);
        cell.setCellValue(cellValue);
    }

    public void writePlainPositiveNumberValue(String cellName, Long cellValue) {
        CellReference cellReference = new CellReference(cellName);
        Cell cell = this.fetchOrCreateCell(cellReference);
        if (cellValue > 0L) {
            cell.setCellValue((double)cellValue.longValue());
        } else {
            cell.setBlank();
        }
    }

    public void writeValue(String cellName, String cellValue, String style, ValueOption option) {
        CellReference cellReference = new CellReference(cellName);
        this.writeValue(cellReference, cellValue, style, option);
    }

    public void writeValue(CellReference cellReference, String cellValue, String style, ValueOption option) {
        Cell cell = this.fetchOrCreateCell(cellReference);
        CellStyle cellStyle = CellStyles.getCellStyle(this.sheet, style);
        if (option == ValueOption.POSITIVE_NUMBER) {
            Long value = Long.parseLong(cellValue);
            cell.setCellStyle(cellStyle);
            if (value < 1L) {
                cell.setBlank();
            } else {
                cell.setCellValue((double)value.longValue());
            }
            return;
        }
        if (option == ValueOption.STATUS_TEXT) {
            Status status = Status.valueOf(cellValue);
            cellStyle = status == Status.PASSED ? CellStyles.getCellStyle(this.sheet, "PASS_TEXT_BOLD_CELL_STYLE") : (status == Status.FAILED ? CellStyles.getCellStyle(this.sheet, "FAIL_TEXT_BOLD_CELL_STYLE") : CellStyles.getCellStyle(this.sheet, "SKIP_TEXT_BOLD_CELL_STYLE"));
        }
        cell.setCellStyle(cellStyle);
        cell.setCellValue(cellValue);
    }

    private Cell fetchOrCreateCell(CellReference cellRef) {
        Cell cell;
        XSSFRow row = this.sheet.getRow(cellRef.getRow());
        if (row == null) {
            row = this.sheet.createRow(cellRef.getRow());
        }
        if ((cell = row.getCell((int)cellRef.getCol())) == null) {
            cell = row.createCell((int)cellRef.getCol());
        }
        return cell;
    }

    public void mergeRows(int startRow, int rowsToMerge, int startColumn, int colsToMerge) {
        if (rowsToMerge == 1 && colsToMerge == 1) {
            return;
        }
        this.sheet.addMergedRegion(new CellRangeAddress(startRow, startRow + rowsToMerge - 1, startColumn, startColumn + colsToMerge - 1));
    }

    public void createCellsWithStyleInRange(int startRow, int endRow, int startCol, int endCol) {
        for (int i = startRow; i < endRow; ++i) {
            for (int j = startCol; j < endCol; ++j) {
                CellReference cellRef = new CellReference(i, j);
                Cell cell = this.fetchOrCreateCell(cellRef);
                cell.setCellStyle(CellStyles.getCellStyle(this.sheet, "EMPTY_CELL_STYLE"));
            }
        }
    }

    CellOperations(XSSFSheet sheet) {
        this.sheet = sheet;
    }

    public static CellOperationsBuilder builder() {
        return new CellOperationsBuilder();
    }

    public static class CellOperationsBuilder {
        private XSSFSheet sheet;

        CellOperationsBuilder() {
        }

        public CellOperationsBuilder sheet(XSSFSheet sheet) {
            this.sheet = sheet;
            return this;
        }

        public CellOperations build() {
            return new CellOperations(this.sheet);
        }

        public String toString() {
            return "CellOperations.CellOperationsBuilder(sheet=" + this.sheet + ")";
        }
    }
}

